/*****************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.ui.internal.projectexplorer;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionConstants;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.analyzer.GeneralizedFile;
import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;

public class GPRExplorerActionProvider extends CommonActionProvider {

	private class OpenFileAction extends Action {
		private GeneralizedFile fFile;

		public OpenFileAction (GeneralizedFile file) {
			fFile = file;
		}

		public void run () {
			try {
				GNATbenchUIPlugin.getDefault().openEditor(fFile);
			} catch (PartInitException e) {
				GNATbenchCorePlugin.getDefault().logError(null, e);
			}
		}
	}

	public GPRExplorerActionProvider() {
		// TODO Auto-generated constructor stub
	}

    public void fillActionBars(IActionBars actionBars) {
    	ISelection selection = getContext().getSelection();

    	if (selection instanceof IStructuredSelection) {
    		Object sel = ((IStructuredSelection) selection).getFirstElement();
    		GeneralizedFile file = (GeneralizedFile) GNATbenchCorePlugin
					.getAdapter(sel, GeneralizedFile.class);

    		if (file != null && !file.getFileStore().fetchInfo().isDirectory()) {
				actionBars.setGlobalActionHandler(ICommonActionConstants.OPEN,
						new OpenFileAction(file));
			}
    	}
    }

}
