/*****************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.ui.internal.projectexplorer;

import java.util.LinkedList;

import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.GNATbenchSession;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.filesystem.FileStoreReference;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistry;
import com.adacore.gnatbench.library.LibraryMonitor;
import com.adacore.gnatbench.library.LibrarySemaphore;
import com.adacore.gnatbench.library.GNATCOLL.VFS.File_Array;
import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;

public class AdaRuntimeNode implements IWorkbenchAdapter {

	private IProject fPrj;
	private Object fParent;

	public AdaRuntimeNode (Object parent, IProject prj) {
		fPrj = prj;
	}

	public Object[] getChildren(Object o) {
		GNATProjectRegistry kernel = (GNATProjectRegistry) GNATbenchSession
				.getDefault().getOrLoadRegistry(fPrj);

		LinkedList <String> runtimeFiles = new LinkedList <String> ();
		LinkedList <Object> result = new LinkedList <Object> ();

		LibraryMonitor monitor = LibrarySemaphore.startGPSWork();

		try {
			File_Array array = kernel.getProjectRegistry()
					.Get_Predefined_Source_Files();

			for (int i = 1; i <= array.Length(); ++i) {
				runtimeFiles.add(array.Get_Element_At(i).Full_Name(true)
						.toString());
			}
		} finally {
			LibrarySemaphore.stopGPSWork(monitor);
		}

		try {
			for (String filePath : runtimeFiles) {
				result.add(new FileStoreReference(GNATbenchCorePlugin
						.getDefault().getEFSRegistry().getUniqueStore(
								URIUtil.toURI(filePath)), fPrj));
			}
		} catch (GNATbenchCoreException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		}

		return result.toArray();
	}

	public ImageDescriptor getImageDescriptor(Object object) {
		return GNATbenchUIPlugin.getDefault().getImageDescriptor(
				GNATbenchUIPlugin.ICON_LIBRARY);
	}

	public String getLabel(Object o) {
		GNATProjectRegistry registry = (GNATProjectRegistry) GNATbenchSession
				.getDefault().getOrLoadRegistry(fPrj);

		return "Ada Runtime [GNAT " + registry.getVersion() + "]";
	}

	public Object getParent(Object o) {
		// TODO Auto-generated method stub
		return fParent;
	}

}
