/*****************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.ui.internal.projectexplorer;

import java.util.LinkedList;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.filesystem.FileStoreReference;
import com.adacore.gnatbench.core.internal.gpswrappers.GPRProject;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistry;
import com.adacore.gnatbench.core.projects.IGNATProjectView;
import com.adacore.gnatbench.library.LibraryMonitor;
import com.adacore.gnatbench.library.LibrarySemaphore;
import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;

public class AdaDependenciesNode implements IWorkbenchAdapter {

	private GNATProjectRegistry fRegistry;
	private IPath fPath;

	public static QualifiedName fgProjectName = new QualifiedName
	("com.adacore.gnatbench.ui.internal.projectexplorer", "projectName");
	public static QualifiedName fgProjectKernel = new QualifiedName
	("com.adacore.gnatbench.ui.internal.projectexplorer", "kernel");

	public AdaDependenciesNode (GNATProjectRegistry registry, IPath path) {
		fRegistry = registry;
		fPath = path;
	}

	public Object[] getChildren(Object o) {
		LinkedList <Object> result = new LinkedList <Object> ();

		GPRProject gpr = fRegistry.getProjectFromLocation(fPath);

		LibraryMonitor monitor = LibrarySemaphore.startGPSWork();

		try {
			LinkedList <IGNATProjectView> deps = gpr.getDependencies(false);

			for (IGNATProjectView prj : deps) {
				IFileStore projectStore = ((GPRProject) prj).getProjectFile();

				IProject prjDep = prj.getEclipseProject();

				if (prjDep != null) {
					GNATbenchCorePlugin.getDefault().getEFSRegistry()
							.setSessionProperty(projectStore, fgProjectName,
									prjDep.getName());
				} else {
					GNATbenchCorePlugin.getDefault().getEFSRegistry()
							.setSessionProperty(projectStore, fgProjectName,
									prj.getName());
				}

				GNATbenchCorePlugin.getDefault().getEFSRegistry()
						.setSessionProperty(projectStore, fgProjectKernel,
								fRegistry);

				FileStoreReference ref = new FileStoreReference(projectStore,
						prjDep);
				ref.setProject(true);
				result.add(ref);
			}
		} catch (GNATbenchCoreException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		} finally {
			LibrarySemaphore.stopGPSWork(monitor);
		}

		return result.toArray();
	}

	public ImageDescriptor getImageDescriptor(Object object) {
		return GNATbenchUIPlugin.getDefault().getImageDescriptor(
				GNATbenchUIPlugin.ICON_LIBRARY);
	}

	public String getLabel(Object o) {
		return "Project Dependencies";
	}

	public Object getParent(Object o) {
		return null;
	}

}
