/*******************************************************************************
 * Copyright (c) 2007 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.preferences;

import org.eclipse.ui.IWorkbench;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.preferences.AdaPreferencePage;

public class AdaEditor extends AdaPreferencePage {
	
	public AdaEditor() {
		super(GRID, "com.adacore.gnatbench.ui.AdaEditor");
	}


	/**
	 * Creates the field editors. Field editors are abstractions of
	 * the common GUI blocks needed to manipulate various types
	 * of preferences. Each field editor knows how to save and
	 * restore itself.
	 */
	public void createFieldEditors() {
		GNATbenchCorePlugin.getDefault().createPreferenceFields(this);
	}

	public void init(IWorkbench workbench) {
	}
}