/*****************************************************************************
 * Copyright (C) 2005-2009 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/
package com.adacore.gnatbench.ui.internal.launching;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.adacore.gnatbench.core.GNATbenchSession;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.gpswrappers.GPRProject;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistry;

public class AdaDebugTabGroup extends AbstractLaunchConfigurationTabGroup {

	public class MainTab extends AbstractLaunchConfigurationTab {

		private Text fExecNameWidget;
		private Combo fPrjNameWidget;
		private ILaunchConfigurationWorkingCopy fConfiguration;


		/*
		 * (non-Javadoc)
		 *
		 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#createControl(org.eclipse.swt.widgets.Composite)
		 */
		public void createControl(Composite parent) {
			Composite baseComp = new Composite(parent, SWT.NONE);
			setControl(baseComp);

			GridLayout topLayout = new GridLayout();
			baseComp.setLayout(topLayout);

			Composite locationComp = new Composite(baseComp, SWT.NONE);
			GridLayout locationLayout = new GridLayout();
			locationLayout.numColumns = 2;
			locationLayout.marginHeight = 0;
			locationLayout.marginWidth = 0;
			locationComp.setLayout(locationLayout);
			GridData gd = new GridData(GridData.FILL_HORIZONTAL);
			locationComp.setLayoutData(gd);

			// Project selection

			Label prjLabel = new Label(locationComp, SWT.NONE);
			prjLabel.setText("Project:");

			gd = new GridData();
			gd.horizontalSpan = 2;
			prjLabel.setLayoutData(gd);

			fPrjNameWidget = new Combo(locationComp, SWT.SINGLE | SWT.BORDER);
			final Combo prjList = fPrjNameWidget;
			gd = new GridData(GridData.FILL_HORIZONTAL);
			prjList.setLayoutData(gd);

			IProject[] projects = ResourcesPlugin.getWorkspace().getRoot()
					.getProjects();

			for (int j = 0; j < projects.length; ++j) {
				GNATProjectRegistry registry = ((GNATProjectRegistry) GNATbenchSession
						.getDefault().getOrLoadRegistry(projects[j]));

				if (registry != null && registry.isValid()) {
					GPRProject gprProject = registry.getGPRFor(projects[j]);

					if (gprProject != null) {
						prjList.add(projects[j].getName());
					}
				}
			}

			prjList.addModifyListener(new ModifyListener(){

				public void modifyText(ModifyEvent e) {
					if (fConfiguration != null) {
						fConfiguration.setAttribute("project_name", prjList
								.getText());
						getLaunchConfigurationDialog().updateButtons();
					}
				}
				});

			// Executable location

			Label execLabel = new Label(locationComp, SWT.NONE);
			execLabel.setText("Location of the executable:");
			gd = new GridData();
			gd.horizontalSpan = 2;
			execLabel.setLayoutData(gd);

			fExecNameWidget = new Text(locationComp, SWT.SINGLE | SWT.BORDER);
			final Text execText = fExecNameWidget;
			gd = new GridData(GridData.FILL_HORIZONTAL);
			execText.setLayoutData(gd);

			execText.addModifyListener(new ModifyListener(){

				public void modifyText(ModifyEvent e) {
					if (fConfiguration != null) {
						fConfiguration.setAttribute("file_name", execText
								.getText());
						getLaunchConfigurationDialog().updateButtons();
					}
				}
				});

			Button execButton = createPushButton (locationComp, "Browse", null);
			execButton.addMouseListener(new MouseListener() {

				public void mouseDoubleClick(MouseEvent e) {
					// TODO Auto-generated method stub

				}

				public void mouseDown(MouseEvent e) {
					// TODO Auto-generated method stub

				}

				public void mouseUp(MouseEvent e) {
					String path = new FileDialog(getShell()).open();

					if (path != null) execText.setText(path);
				}
			});
		}

		/*
		 * (non-Javadoc)
		 *
		 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#setDefaults(org.eclipse.debug.core.ILaunchConfigurationWorkingCopy)
		 */
		public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
			// TODO Auto-generated method stub

		}

		/*
		 * (non-Javadoc)
		 *
		 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#initializeFrom(org.eclipse.debug.core.ILaunchConfiguration)
		 */
		public void initializeFrom(ILaunchConfiguration configuration) {
			try {
				fExecNameWidget.setText(configuration.getAttribute("file_name", ""));
				fPrjNameWidget.setText(configuration.getAttribute("project_name", ""));
			} catch (CoreException e) {
				GNATbenchCorePlugin.getDefault().logError(null, e);
			}
		}

		/*
		 * (non-Javadoc)
		 *
		 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#performApply(org.eclipse.debug.core.ILaunchConfigurationWorkingCopy)
		 */
		public void performApply(ILaunchConfigurationWorkingCopy configuration) {
			fConfiguration = configuration;
		}

		/*
		 * (non-Javadoc)
		 *
		 * @see org.eclipse.debug.ui.ILaunchConfigurationTab#getName()
		 */
		public String getName() {
			return "Main Ada program";
		}

		public boolean isValid(ILaunchConfiguration config) {
			return true;
		}

		public boolean canSave() {
			return true;
		}

	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTabGroup#createTabs(org.eclipse.debug.ui.ILaunchConfigurationDialog,
	 *      java.lang.String)
	 */
	public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
		setTabs(new ILaunchConfigurationTab[] { new MainTab() });
	}
}