/*******************************************************************************
 * Copyright (c) 2005, 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/
package com.adacore.gnatbench.ui.internal.launching;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;

import com.adacore.gnatbench.core.GNATbenchSession;
import com.adacore.gnatbench.core.internal.GPS;
import com.adacore.gnatbench.core.internal.gpswrappers.GPRProject;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistry;

/**
 * @author Quentin Ochem
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class AdaDebugLauncher extends LaunchConfigurationDelegate {	
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.ILaunchConfigurationDelegate#launch(org.eclipse.debug.core.ILaunchConfiguration, java.lang.String, org.eclipse.debug.core.ILaunch, org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void launch(ILaunchConfiguration configuration, String mode,
			ILaunch launch, IProgressMonitor monitor) throws CoreException {
		
		IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(
				configuration.getAttribute("project_name", ""));
		
		GPRProject gpr = ((GNATProjectRegistry) GNATbenchSession.getDefault()
				.getOrLoadRegistry(prj)).getGPRFor(prj);
		
		final Process proc = GPS.launchGPS(gpr, "debug.py", " --debug=\"\\\""
				+ configuration.getAttribute("file_name", "").replaceAll(
						"\\\\", "/") + "\\\"\"");
		
		final ILaunch thisLaunch = launch; 
		
		launch.addProcess(new IProcess () {
			
			boolean terminated = false;

			public String getAttribute(String key) {
				// TODO Auto-generated method stub
				return null;
			}

			public int getExitValue() throws DebugException {
				// TODO Auto-generated method stub
				return proc.exitValue();
			}

			public String getLabel() {
				// TODO Auto-generated method stub
				return "GPS debugger";
			}

			public ILaunch getLaunch() {
				return thisLaunch;
			}

			public IStreamsProxy getStreamsProxy() {
				// TODO Auto-generated method stub
				return null;
			}

			public void setAttribute(String key, String value) {
				// TODO Auto-generated method stub
				
			}

			@SuppressWarnings("unchecked")
			public Object getAdapter(Class adapter) {
				// TODO Auto-generated method stub
				return null;
			}

			public boolean canTerminate() {
				return true;
			}

			public boolean isTerminated() {
				try {
					proc.exitValue();
					
					return true;
				} catch (IllegalThreadStateException e) {
					return terminated;
				}
			}

			public void terminate() throws DebugException {
				proc.destroy();
				terminated = true;
			}});
	}

}
