/*******************************************************************************
 * Copyright (c) 2007 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.gpreditor;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

import com.adacore.gnatbench.core.internal.adaeditor.AdaCharacterRule;
import com.adacore.gnatbench.core.internal.adaeditor.AdaStringRule;
import com.adacore.gnatbench.core.internal.adaeditor.AdaWordDetector;

public class GPRScanner extends RuleBasedScanner {
	
	public GPRScanner(ColorManager manager) {
		
		IToken comment =
			new Token(
				new TextAttribute(
					manager.getColor(IGPRColorConstants.COMMENT)));		
		
		IToken string =
			new Token(
				new TextAttribute(
					manager.getColor(IGPRColorConstants.STRING)));

		IToken keyword =
			new Token(
				new TextAttribute(
					manager.getColor(IGPRColorConstants.RESERVED_WORD)));
		
		IToken userWords =
			new Token(
				new TextAttribute(
					manager.getColor(IGPRColorConstants.DEFAULT)));
		
        List <IRule> rules = new ArrayList<IRule>();

        rules.add(new EndOfLineRule("--", comment)); //$NON-NLS-1$

        rules.add(new AdaCharacterRule(string));

        rules.add(new AdaStringRule(string));
		
		WordRule word = new WordRule(new AdaWordDetector(), userWords);
		
		// reserved words
		
		word.addWord("package",keyword);
		word.addWord("project",keyword);
		word.addWord("case",keyword);
		word.addWord("when",keyword);
		word.addWord("is",keyword);
		word.addWord("for",keyword);
		word.addWord("type",keyword);
		word.addWord("use",keyword);
		word.addWord("end",keyword);
		word.addWord("extends",keyword);
		word.addWord("renames",keyword);
		word.addWord("others",keyword);
		word.addWord("with",keyword);
		word.addWord("null",keyword);
		word.addWord("external",keyword);

        rules.add(word);
        
		// Add generic whitespace rule.
		rules.add(new WhitespaceRule(new GPRWhitespaceDetector()));

        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        setRules(result);		
	}
	
}
