/*******************************************************************************
 * Copyright (c) 2007 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.gpreditor;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.text.rules.*;

import com.adacore.gnatbench.core.internal.adaeditor.AdaCharacterRule;
import com.adacore.gnatbench.core.internal.adaeditor.AdaStringRule;

public class GPRPartitionScanner extends RuleBasedPartitionScanner {
    public final static String GPR_COMMENT = "__gpr_comment"; //$NON-NLS-1$
    public final static String GPR_CHARACTER = "__gpr_character";
    public final static String GPR_STRING = "__gpr_string";
    
    
    public final static String[] GPR_PARTITION_TYPES= new String[]
       {GPR_COMMENT, GPR_CHARACTER, GPR_STRING};
	
	
	
	public GPRPartitionScanner() {

        IToken comment= new Token(GPR_COMMENT);
        IToken string = new Token (GPR_STRING);

        List <IRule> rules= new ArrayList<IRule>();

        rules.add (new EndOfLineRule("--", comment)); //$NON-NLS-1$
        
        rules.add (new AdaCharacterRule (string));
        
        rules.add (new AdaStringRule (string));
        
        IPredicateRule[] result= new IPredicateRule[rules.size()];
        rules.toArray(result);
        setPredicateRules(result);
	}
}
