package com.adacore.gnatbench.ui.internal.gpreditor;

import com.adacore.gnatbench.ui.internal.adaeditor.AdaEditor;

public class GPREditor extends AdaEditor  {
	
	// note we need a different color handling because we we want the 
	// gpr editor to recognize "project" as a reserved word
	
	private ColorManager colorManager;

	public GPREditor() {
		super();
		colorManager = new ColorManager();
		setSourceViewerConfiguration(new GPRConfiguration(colorManager));
		setDocumentProvider(new GPRDocumentProvider());
	}
	
	public void dispose() {
		colorManager.dispose();
		super.dispose();
	}

	protected void createActions() {
		super.createActions();

		// these actions don't work or don't make sense with gpr editors
		
		setAction("OpenCallHierarchy", null);
		setAction("CorrectIndent", null);
		setAction("Insert End", null);
		setAction("Expand Ada Syntax", null);
		setAction("Next Ada Subprogram", null);
		setAction("Previous Ada Subprogram", null);
		setAction("OpenDeclaration", null);
		setAction("OpenBody", null);
		setAction("ReferencesInProject", null);
		setAction("ReferencesInWorkspace", null);
//		setAction("CompileFile", null);
		setAction("GenerateBody", null);
		
		// this leaves the following actions for GPR files:

		// setAction("ToggleComment", action);
		// setAction("Refill", action);	
		// setAction("TabIndent", action);		
	}
	
}
