/*****************************************************************************
 * Copyright (c) 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.ui.internal.filesystem;

import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ui.model.IWorkbenchAdapter;

import com.adacore.gnatbench.core.internal.analyzer.GeneralizedFile;
import com.adacore.gnatbench.core.internal.filesystem.FileStoreReference;

public class FileStoreWorkbenchAdapterFactory implements IAdapterFactory {

	@SuppressWarnings("unchecked")
	public Object getAdapter(Object adaptableObject, Class adapterType) {
		if (!(adaptableObject instanceof FileStoreReference)) {
			return null;
		}
		
		FileStoreReference ref = (FileStoreReference) adaptableObject;
		
		if (IWorkbenchAdapter.class.isAssignableFrom(adapterType)) {
			if (adaptableObject instanceof FileStoreReference) {
				return new FileStoreWorkbenchAdapter(ref.getFileStore());
			}
		} else if (GeneralizedFile.class.isAssignableFrom(adapterType)) {
			IProject project = null;
			
			if (ref.getResource() != null) {
				project = ref.getResource().getProject ();
			}
			
			return GeneralizedFile.fromOSPath(project, URIUtil.toPath(
					ref.getFileStore().toURI()).toOSString());
		}
		
		return null;
	}

	@SuppressWarnings("unchecked")
	public Class[] getAdapterList() {
		return new Class [] {IWorkbenchAdapter.class, GeneralizedFile.class};
	}

}
