/*****************************************************************************
 * Copyright (c) 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.ui.internal.filesystem;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;

public class FileStoreWorkbenchAdapter implements IWorkbenchAdapter {

	private IFileStore fResource;
	
	public FileStoreWorkbenchAdapter (IFileStore resource) {
		fResource = resource;
	}
	
	public Object[] getChildren(Object o) {
		return new Object [0];
	}

	public ImageDescriptor getImageDescriptor(Object object) {
		return GNATbenchUIPlugin.getDefault().getImageDescriptor(
				GNATbenchUIPlugin.ICON_FILE);
	}

	public String getLabel(Object o) {
		return fResource.getName();
	}

	public Object getParent(Object o) {
		return null;
	}

}
