/*******************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.compiler;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.jobs.AnalyzeAdaFilesJob;
import com.adacore.gnatbench.core.internal.jobs.CommandFilesJob;

/**
 * This action analyzes a file(s) and computes the output.
 *
 */
public class AnalyzeAdaFileAction implements IObjectActionDelegate {

	ISelection fSelection;

	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	public void run(IAction action) {
		final IStructuredSelection selection = (IStructuredSelection) fSelection;
		IFileStore[] resources = CommandFilesJob.selectionToIFileStore(selection.toArray());

		if (resources == null){
			GNATbenchCorePlugin.getDefault()
				.logError("Problem occured with the selection", null);
			return;
		}
		new AnalyzeAdaFilesJob(resources, true).schedule();

	}

	public void selectionChanged(IAction action, ISelection selection) {
		fSelection = selection;
	}
}
