/*******************************************************************************
 * Copyright (c) 2005, 2007 AdaCore and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.codingstyle;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;

import com.adacore.gnatbench.core.internal.adaeditor.AdaDocumentBuffer;

/**
 * This is the master class for auto edit strategies. The other ones should not
 * be added directly to the editor, but created and called from this.
 * 
 * @author ochem
 */
public class AdaMainAutoEditStrategy extends AdaAutoEditStrategy {

	private AdaDocumentBuffer fBuffer;
	private String fExtraString;
	
	public AdaMainAutoEditStrategy(AdaDocumentBuffer buffer) {
		fBuffer = buffer;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.text.IAutoEditStrategy#customizeDocumentCommand(org.eclipse.jface.text.IDocument, org.eclipse.jface.text.DocumentCommand)
	 */
	public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
		if (command.text.indexOf('\n') == -1) return;
		
		new AdaAutoIndent(fBuffer, this).customizeDocumentCommand(document, command);

		int firstExtraNonBlank = 0;
		
		// Removes the blank characters of the extra string that might have 
		// been removed already by the indentation process.
		while (firstExtraNonBlank < fExtraString.length() &&
				   (fExtraString.charAt(firstExtraNonBlank) == ' ' || 
				   	fExtraString.charAt(firstExtraNonBlank) == '\t' ||
				   	fExtraString.charAt(firstExtraNonBlank) == '\n' ||
				   	fExtraString.charAt(firstExtraNonBlank) == '\r')) {
			firstExtraNonBlank++;
		}

		int lastOffset = command.text.length() - 
		   (fExtraString.length() - firstExtraNonBlank);
		
		// Passes the blank characters of the new text.
		while (lastOffset < command.text.length() &&
			   (command.text.charAt(lastOffset) == ' ' || 
			   command.text.charAt(lastOffset) == '\t' ||
			   command.text.charAt(lastOffset) == '\n' ||
			   command.text.charAt(lastOffset) == '\r')) {
			lastOffset++;
		}
			
		int remaining = command.text.length() - lastOffset;
		
		command.text = command.text.substring(0, command.text.length() - remaining);
		command.length = command.length - remaining;
	}

	/**
	 * During the document customization, some extra-text might be added at the
	 * end of the command.text, but removed after. This function stores the 
	 * string that has to be removed. Spaces at the begining of this string 
	 * are supposed to be processed by auto-identation, therefore the text 
	 * that will be "removed" from the command start on the first actual word.
	 */
	public void setExtraString(String extraString) {
		fExtraString = extraString;
	}
	
}
