/*******************************************************************************
 * Copyright (c) 2007, 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.codingstyle;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.preferences.AdaPreferencePage;
import com.adacore.gnatbench.core.internal.preferences.IGNATbenchPreferencesProvider;
import com.adacore.gnatbench.library.LibraryMonitor;
import com.adacore.gnatbench.library.LibrarySemaphore;
import com.adacore.gnatbench.library.Case_Handling.Casing_Policy;
import com.adacore.gnatbench.library.Case_Handling.Casing_Type;
import com.adacore.gnatbench.library.Language.Indent_Parameters;
import com.adacore.gnatbench.library.Language.Indent_Style;
import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;

public class AdaCodingStylePreferencesProvider implements
		IGNATbenchPreferencesProvider {

	//  NB: It would be great if the public static fields could be made 
	//  private
	
	private static Indent_Parameters fgIndentParams;

	public static final String PREF_INDENT_LEVEL = GNATbenchUIPlugin.getId()
			+ ".preferences.codingstyle.indentlevel";
	private static final String PREF_INDENT_CONTINUE = GNATbenchUIPlugin.getId()
			+ ".preferences.codingstyle.indentcontinue";
	private static final String PREF_INDENT_CONDITIONAL = GNATbenchUIPlugin.getId()
			+ ".preferences.codingstyle.indentconditional";
	private static final String PREF_INDENT_RECORD = GNATbenchUIPlugin.getId()
			+ ".preferences.codingstyle.indentrecord";
	private static final String PREF_INDENT_DECL = GNATbenchUIPlugin.getId()
			+ ".preferences.codingstyle.indentdecl";
	private static final String PREF_TAB_WIDTH = GNATbenchUIPlugin.getId()
			+ ".preferences.codingstyle.tabwidth";
	private static final String PREF_INDENT_CASE_EXTRA = GNATbenchUIPlugin.getId()
			+ ".preferences.codingstyle.indentcaseextra";
	private static final String PREF_CASING_POLICY = GNATbenchUIPlugin.getId()
			+ ".preferences.codingstyle.casingpolicy";
	public static final String PREF_RESERVED_CASING = GNATbenchUIPlugin.getId()
			+ ".preferences.codingstyle.reservedcasing";
	public static final String PREF_IDENT_CASING = GNATbenchUIPlugin.getId()
			+ ".preferences.codingstyle.indentcasing";
	private static final String PREF_FORMAT_OPERATORS = GNATbenchUIPlugin.getId()
			+ ".preferences.codingstyle.formatoperators";
	private static final String PREF_USE_TABS = GNATbenchUIPlugin.getId()
			+ ".preferences.codingstyle.usetabls";
	private static final String PREF_ALIGN_ON_COLONS = GNATbenchUIPlugin.getId()
			+ ".preferences.codingstyle.alignoncolons";
	private static final String PREF_ALIGN_ON_ARROWS = GNATbenchUIPlugin.getId()
			+ ".preferences.codingstyle.alignonarrows";
	private static final String PREF_ALIGN_DECL_ON_COLON = GNATbenchUIPlugin.getId()
			+ ".preferences.codingstyle.aligndecloncolon";
	private static final String PREF_INDENT_COMMENTS = GNATbenchUIPlugin.getId()
			+ ".preferences.codingstyle.indentcomments";
	private static final String PREF_STICK_COMMENTS = GNATbenchUIPlugin.getId()
			+ ".preferences.codingstyle.stickcomments";
	
	private static final String VAL_AUTOMATIC = "automatic";
	private static final String VAL_RM_STYLE = "rm_style";
	private static final String VAL_NON_RM_STYLE = "non_rm_style";

	private static final String[][] VALUES_INDENT_CASE_EXTRA = {
			{ "automatic", VAL_AUTOMATIC },
			{ "RM style", VAL_RM_STYLE },
			{ "non RM style", VAL_NON_RM_STYLE  } };
	
	private static final String VAL_DISABLED = "disabled";
	private static final String VAL_END_OF_LINE = "end_of_file";
	private static final String VAL_ON_THE_FLY = "on_the_file";
	
	private static final String[][] VALUES_CASING_POLICY = {
		{ "disabled", VAL_DISABLED },
		{ "end of line", VAL_END_OF_LINE },
		{ "on the fly", VAL_ON_THE_FLY  } };
	
	public static final String VAL_UNCHANGED = "unchanged";
	public static final String VAL_UPPER = "upper";
	public static final String VAL_LOWER = "lower";
	public static final String VAL_MIXED = "mixed";
	public static final String VAL_SMART_MIXED = "smart mixed";
	
	private static final String[][] VALUES_CASING_TYPE = {
		{ "none", VAL_UNCHANGED },
		{ "UPPER_CASE", VAL_UPPER },
		{ "lower_case", VAL_LOWER  },
		{ "Mixed_Case", VAL_MIXED  },
		{ "Smart_CASE", VAL_SMART_MIXED  } };
	
	private static final int DEFAULT_INDENT_LEVEL = 3;
	private static final int DEFAULT_INDENT_CONTINUE = 2;
	private static final int DEFAULT_INDENT_CONDITIONAL = 1;
	private static final int DEFAULT_INDENT_RECORD = 3;
	private static final int DEFAULT_INDENT_DECL = 0;
	private static final int DEFAULT_TAB_WIDTH = 8;
	private static final String DEFAULT_INDENT_CASE_EXTRA = VAL_AUTOMATIC;
	private static final String DEFAULT_CASING_POLICY = VAL_DISABLED;
	private static final String DEFAULT_RESERVED_CASING = VAL_UNCHANGED;
	private static final String DEFAULT_IDENT_CASING = VAL_UNCHANGED;
	private static final boolean DEFAULT_FORMAT_OPERATORS = false;
	private static final boolean DEFAULT_USE_TABS = false;
	private static final boolean DEFAULT_ALIGN_ON_COLONS = false;
	private static final boolean DEFAULT_ALIGN_ON_ARROWS = false;
	private static final boolean DEFAULT_ALIGN_DECL_ON_COLON = false;
	private static final boolean DEFAULT_INDENT_COMMENTS = true;
	private static final boolean DEFAULT_STICK_COMMENTS = false;

	public void createPreferenceFields(AdaPreferencePage page) {
		page.addField(new IntegerFieldEditor(PREF_INDENT_LEVEL,
				"Default indentation", page.getFieldEditorParent()));
		page.addField(new IntegerFieldEditor(PREF_INDENT_CONTINUE,
				"Continuation lines", page.getFieldEditorParent()));
		page.addField(new IntegerFieldEditor(PREF_INDENT_CONDITIONAL,
				"Conditional continuation lines", page.getFieldEditorParent()));
		page.addField(new IntegerFieldEditor(PREF_INDENT_RECORD,
				"Record indentation", page.getFieldEditorParent()));
		page.addField(new IntegerFieldEditor(PREF_INDENT_DECL,
				"Declaration lines", page.getFieldEditorParent()));
		
		page.addField(new RadioGroupFieldEditor(PREF_INDENT_CASE_EXTRA,
				"Case indentation", 3, VALUES_INDENT_CASE_EXTRA,
				page.getFieldEditorParent()));
		page.addField(new RadioGroupFieldEditor(PREF_RESERVED_CASING,
				"Reserved words casing", 5, VALUES_CASING_TYPE,
				page.getFieldEditorParent()));
		page.addField(new RadioGroupFieldEditor(PREF_IDENT_CASING,
				"Identifier casing", 5, VALUES_CASING_TYPE,
				page.getFieldEditorParent()));
		
		page.addField(new BooleanFieldEditor(PREF_FORMAT_OPERATORS,
				"Format operators / delimiters", page.getFieldEditorParent()));
		page.addField(new BooleanFieldEditor(PREF_USE_TABS,
				"Use tabulations", page.getFieldEditorParent()));
		page.addField(new BooleanFieldEditor(PREF_ALIGN_ON_COLONS,
				"Align colons in declarations", page.getFieldEditorParent()));
		page.addField(new BooleanFieldEditor(PREF_ALIGN_ON_ARROWS,
				"Align associations on arrows", page.getFieldEditorParent()));
		page.addField(new BooleanFieldEditor(PREF_ALIGN_DECL_ON_COLON,
				"Align declaration after colon", page.getFieldEditorParent()));
		page.addField(new BooleanFieldEditor(PREF_INDENT_COMMENTS,
				"Indent comments", page.getFieldEditorParent()));
		page.addField(new BooleanFieldEditor(PREF_STICK_COMMENTS,
				"Align comments on keywords", page.getFieldEditorParent()));
	}

	public void initializeDefaultPreferences(IPreferenceStore store) {
		store.setDefault(PREF_INDENT_LEVEL, DEFAULT_INDENT_LEVEL);
		store.setDefault(PREF_INDENT_CONTINUE, DEFAULT_INDENT_CONTINUE);
		store.setDefault(PREF_INDENT_CONDITIONAL, DEFAULT_INDENT_CONDITIONAL);
		store.setDefault(PREF_INDENT_RECORD, DEFAULT_INDENT_RECORD);
		store.setDefault(PREF_INDENT_DECL, DEFAULT_INDENT_DECL);		
		store.setDefault(PREF_INDENT_CASE_EXTRA, DEFAULT_INDENT_CASE_EXTRA);
		store.setDefault(PREF_RESERVED_CASING, DEFAULT_RESERVED_CASING);
		store.setDefault(PREF_IDENT_CASING, DEFAULT_IDENT_CASING);
		store.setDefault(PREF_FORMAT_OPERATORS, DEFAULT_FORMAT_OPERATORS);
		store.setDefault(PREF_USE_TABS, DEFAULT_USE_TABS);
		store.setDefault(PREF_ALIGN_ON_COLONS, DEFAULT_ALIGN_ON_COLONS);
		store.setDefault(PREF_ALIGN_ON_ARROWS, DEFAULT_ALIGN_ON_ARROWS);
		store.setDefault(PREF_ALIGN_DECL_ON_COLON, DEFAULT_ALIGN_DECL_ON_COLON);
		store.setDefault(PREF_INDENT_COMMENTS, DEFAULT_INDENT_COMMENTS);
		store.setDefault(PREF_STICK_COMMENTS, DEFAULT_STICK_COMMENTS);
	}

	public void okPerformed(AdaPreferencePage page) {
		refreshIndentParameters(GNATbenchCorePlugin.getDefault());
	}
	
	public static void refreshIndentParameters (GNATbenchCorePlugin plugin) {
		fgIndentParams = getIndentParameters();
		
		GNATbenchCorePlugin.getDefault().setIndentParameters(fgIndentParams);
	}
	
	private static Indent_Parameters getIndentParameters () {
		IPreferenceStore store = GNATbenchCorePlugin.getDefault()
				.getPreferenceStore();
		
		LibraryMonitor libMonitor = LibrarySemaphore.startGPSWork();

		try {
			Indent_Parameters params = new Indent_Parameters ();
			
			params.Indent_Level(store.getInt(PREF_INDENT_LEVEL));
			params.Indent_Continue(store.getInt(PREF_INDENT_CONTINUE));
			params.Indent_Conditional(store.getInt(PREF_INDENT_CONDITIONAL));
			params.Indent_Record(store.getInt(PREF_INDENT_RECORD));
			params.Indent_Decl(store.getInt(PREF_INDENT_DECL));
			params.Tab_Width(DEFAULT_TAB_WIDTH);
			
			String val = store.getString(PREF_INDENT_CASE_EXTRA);
			
			if (val.equals(VAL_AUTOMATIC)) {
				params.Indent_Case_Extra(Indent_Style.Automatic);
			} else if (val.equals(VAL_RM_STYLE)) {
				params.Indent_Case_Extra(Indent_Style.RM_Style);
			} else if (val.equals(VAL_NON_RM_STYLE)) {
				params.Indent_Case_Extra(Indent_Style.Non_RM_Style);
			}
			
			
			params.Casing_Policy(Casing_Policy.End_Of_Line);
			
			val = store.getString(PREF_RESERVED_CASING);
			
			if (val.equals(VAL_UNCHANGED)) {
				params.Reserved_Casing(Casing_Type.Unchanged);
			} else if (val.equals(VAL_UPPER)) {
				params.Reserved_Casing(Casing_Type.Upper);
			} else if (val.equals(VAL_LOWER)) {
				params.Reserved_Casing(Casing_Type.Lower);
			} else if (val.equals(VAL_MIXED)) {
				params.Reserved_Casing(Casing_Type.Mixed);
			} else if (val.equals(VAL_SMART_MIXED)) {
				params.Reserved_Casing(Casing_Type.Smart_Mixed);
			}
			
			val = store.getString(PREF_IDENT_CASING);
			
			if (val.equals(VAL_UNCHANGED)) {
				params.Ident_Casing(Casing_Type.Unchanged);
			} else if (val.equals(VAL_UPPER)) {
				params.Ident_Casing(Casing_Type.Upper);
			} else if (val.equals(VAL_LOWER)) {
				params.Ident_Casing(Casing_Type.Lower);
			} else if (val.equals(VAL_MIXED)) {
				params.Ident_Casing(Casing_Type.Mixed);
			} else if (val.equals(VAL_SMART_MIXED)) {
				params.Ident_Casing(Casing_Type.Smart_Mixed);
			}
			
			params.Format_Operators(store.getBoolean(PREF_FORMAT_OPERATORS));
			params.Use_Tabs(store.getBoolean(PREF_USE_TABS));
			params.Align_On_Colons(store.getBoolean(PREF_ALIGN_ON_COLONS));
			params.Align_On_Arrows(store.getBoolean(PREF_ALIGN_ON_ARROWS));
			params.Align_Decl_On_Colon(store.getBoolean(PREF_ALIGN_DECL_ON_COLON));
			params.Indent_Comments(store.getBoolean(PREF_INDENT_COMMENTS));
			params.Stick_Comments(store.getBoolean(PREF_STICK_COMMENTS));
			
			return params;
		} finally {
			LibrarySemaphore.stopGPSWork(libMonitor);
		}
	}

}
