/*******************************************************************************
 * Copyright (c) 2006, 2007 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.codingstyle;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;

import com.adacore.gnatbench.core.internal.preferences.AdaPreferencePage;
import com.adacore.gnatbench.core.internal.preferences.IGNATbenchPreferencesProvider;
import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;

public class AdaAutoIndentPreferencesProvider implements
		IGNATbenchPreferencesProvider {

	public static final String PREF_CODINGSTYLE_AUTOINDENT = GNATbenchUIPlugin
			.getId()
			+ ".preferences.codingstyle.autoindent";

	public static final String DEFAULT_PREF_CODINGSTYLE_AUTOINDENT = "extended";
	public static final String VAL_AUTOINDENT_NONE = "none";
	public static final String VAL_AUTOINDENT_SIMPLE = "simple";
	public static final String VAL_AUTOINDENT_EXTENDED = "extended";

	private static final String[][] VALUES_PREF_CODING_STYLE_AUTOINDENT = {
			{ "none", VAL_AUTOINDENT_NONE },
			{ "simple", VAL_AUTOINDENT_SIMPLE },
			{ "extended", VAL_AUTOINDENT_EXTENDED } };
	

	public void createPreferenceFields(AdaPreferencePage page) {
		page.addField(new RadioGroupFieldEditor(PREF_CODINGSTYLE_AUTOINDENT,
				"Coding style mode", 4, VALUES_PREF_CODING_STYLE_AUTOINDENT,
				page.getFieldEditorParent()));
	}

	public void initializeDefaultPreferences(IPreferenceStore store) {
		store.setDefault(PREF_CODINGSTYLE_AUTOINDENT,
				DEFAULT_PREF_CODINGSTYLE_AUTOINDENT);
	}

	public void okPerformed(AdaPreferencePage page) {
		// TODO Auto-generated method stub
		
	}

}
