/*******************************************************************************
 * Copyright (C) 2005-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.codingstyle;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.adaeditor.AdaDocumentBuffer;
import com.adacore.gnatbench.library.LibraryMonitor;
import com.adacore.gnatbench.library.LibrarySemaphore;
import com.adacore.gnatbench.library.Case_Handling.Case_Handling_Package;
import com.adacore.gnatbench.library.Language.Replace_Text_Callback;
import com.adacore.gnatbench.library.Language.Ada.Ada_Package;
import com.adacore.gnatbench.library.Standard.AdaString;

public class AdaAutoIndent extends AdaAutoEditStrategy {

	private DefaultIndentLineAutoEditStrategy defaultStrategy =
		new DefaultIndentLineAutoEditStrategy();

	/**
	 * This array is used to store the offset of each line of the command.
	 */
	private int[] fLinesOffsets;

	/**
	 * Holds the first line number contained in the command, in GPS format.
	 */
	private int fFirstLine;

	private DocumentCommand fCommand;

	private AdaDocumentBuffer fBuffer;

	private AdaMainAutoEditStrategy fMainStrategy;

	class Text_Callback extends Replace_Text_Callback {

		public void Replace_Text_Callback_Body(int Line, int First, int Last, AdaString Replace) {
			int offsetBegin = fLinesOffsets[Line - fFirstLine] + First - 1;
			int offsetEnd = offsetBegin + Last - First;
			String replaceStr = Replace.toString();
			int diffSize = replaceStr.length() - (offsetEnd - offsetBegin);

			fCommand.text = fCommand.text.substring(0, offsetBegin) + replaceStr
					+ fCommand.text.substring(offsetEnd);

			for (int i = Line - fFirstLine + 1; i < fLinesOffsets.length; ++i) {
				fLinesOffsets[i] += diffSize;
			}
		}

	}

	public AdaAutoIndent (AdaDocumentBuffer buffer,
			AdaMainAutoEditStrategy mainStrategy) {
		fBuffer = buffer;
		fMainStrategy = mainStrategy;
	}

	/**
	 * Indent the text from of the current buffer from lineBegin to lineEnd.
	 *
	 * @param text
	 * @param lineBegin
	 * @param lineEnd
	 */
	public void doAutoIndent(String text, int lineBegin, int lineEnd) {
		LibraryMonitor libMonitor = LibrarySemaphore.startGPSWork();

		try {
			Ada_Package.Ada_Lang ().Format_Buffer(
					new AdaString (text),
					new Text_Callback (),
					lineBegin,
					lineEnd,
					GNATbenchCorePlugin.getDefault().getIndentParameters(),
					0,
					Case_Handling_Package.No_Casing_Exception(),
					null);
		} finally {
			LibrarySemaphore.stopGPSWork(libMonitor);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.text.IAutoEditStrategy#customizeDocumentCommand(org.eclipse.jface.text.IDocument, org.eclipse.jface.text.DocumentCommand)
	 */
	public void customizeDocumentCommand(IDocument document,
			DocumentCommand command) {
		if (command.text.indexOf("\n", 0) == -1)
			return;

		fCommand = command;

		try {
			String indentType = GNATbenchCorePlugin
					.getDefault()
					.getPreferenceStore()
					.getString(
							AdaAutoIndentPreferencesProvider.PREF_CODINGSTYLE_AUTOINDENT);

			if (AdaAutoIndentPreferencesProvider.VAL_AUTOINDENT_NONE
					.equals(indentType)) {
				getWholeLine(document, fCommand, fBuffer, fMainStrategy);
				return;
			} else if (AdaAutoIndentPreferencesProvider.VAL_AUTOINDENT_SIMPLE
					.equals(indentType)) {
				defaultStrategy.customizeDocumentCommand(document, fCommand);
				getWholeLine(document, fCommand, fBuffer, fMainStrategy);
			} else if (AdaAutoIndentPreferencesProvider.VAL_AUTOINDENT_EXTENDED
					.equals(indentType)) {
				getWholeLine(document, fCommand, fBuffer, fMainStrategy);

				String text = fBuffer.getContent().substring(0, fCommand.offset)
						+ fCommand.text + "\n";

				fFirstLine = document.getLineOfOffset(fCommand.offset) + 1;

				int lastInd = 0;
				int nbLines = 0;

				while ((lastInd = fCommand.text.indexOf("\n", lastInd) + 1) > 0) {
					nbLines++;
				}

				int lastLine = fFirstLine + nbLines;

				fLinesOffsets = new int[lastLine - fFirstLine + 1];

				fLinesOffsets[0] = 0;
				lastInd = 0;
				int indOffset = 1;

				while ((lastInd = fCommand.text.indexOf("\n", lastInd) + 1) > 0) {
					fLinesOffsets[indOffset] = lastInd;
					indOffset++;
				}

				doAutoIndent(text, fFirstLine, lastLine);
			}

		} catch (BadLocationException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		}
	}
}