/*******************************************************************************
 * Copyright (c) 2005 AdaCore and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.codingstyle;

import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;

import com.adacore.gnatbench.core.internal.adaeditor.AdaDocumentBuffer;

/**
 * @author ochem
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public abstract class AdaAutoEditStrategy implements IAutoEditStrategy{
	
	/**
	 * This functions extends the command given in parameter to the whole line 
	 * instead of only the added characters. Useful when there is processing
	 * to be done on the line.
	 *  
	 * @param document
	 * @param command
	 */
	public void getWholeLine(IDocument document, DocumentCommand command, 
			AdaDocumentBuffer buffer,
			AdaMainAutoEditStrategy mainStrategy) {

		String completeText = buffer.getContent();
				
		int lastLineOffset = completeText.lastIndexOf('\n', command.offset - 1) + 1;
		
		int nextLineOffset = completeText.indexOf('\n', command.offset) - 1;
				
		if (nextLineOffset < 0) {
			if (completeText.length() > 0) {
				nextLineOffset = completeText.length() - 1;
			} else {
				nextLineOffset = 0;
			}
		}
		
		String secondString;
		
		if (command.offset + command.length > nextLineOffset) {
			secondString = "";
		} else {
			secondString = completeText.substring(command.offset
					+ command.length, nextLineOffset);
		}
		
		command.text = completeText.substring(lastLineOffset, command.offset) 
				+ command.text
				+ secondString;
		
		command.length = (command.offset - lastLineOffset)
				+ command.length
				+ secondString.length();
		
		command.offset = lastLineOffset;
			
		mainStrategy.setExtraString(secondString);
	}
}
