/*******************************************************************************
 * Copyright (C) 2005-2009 AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.codingstyle;

import java.util.ResourceBundle;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.ui.texteditor.TextEditorAction;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.codingstyle.AdaIndentBuffer;
import com.adacore.gnatbench.library.LibraryMonitor;
import com.adacore.gnatbench.library.LibrarySemaphore;
import com.adacore.gnatbench.ui.internal.adaeditor.AdaEditor;

public class AdaActionFormat extends TextEditorAction {

	private AdaEditor fEditor;

	/**
	 * @param bundle
	 * @param prefix
	 * @param editor
	 */
	public AdaActionFormat(ResourceBundle bundle, String prefix, AdaEditor editor) {
		super(bundle, prefix, editor);

		fEditor = editor;
	}

	public void run() {
		TextSelection selection = (TextSelection) ((TextViewer) fEditor
				.getSourceViewerPublic()).getSelection();
		LibraryMonitor libMonitor = LibrarySemaphore.startGPSWork();

		try {
			AdaIndentBuffer indentAction = new AdaIndentBuffer(fEditor
					.getDocumentBuffer());

			TextSelection newSelection = indentAction.format(
					selection, false);

			((TextViewer) fEditor.getSourceViewerPublic()).setSelectedRange(
					newSelection.getOffset(), newSelection.getLength());
		} catch (BadLocationException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		} finally {
			LibrarySemaphore.stopGPSWork(libMonitor);
		}
	}
}