package com.adacore.gnatbench.ui.internal.buildtarget;


import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import com.adacore.gnatbench.core.internal.make.IMakefileTarget;
import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;

public class TargetListViewer {

	protected static final String BUILD_TARGET_ICON = "build_target";

    protected TableViewer tableViewer;
    protected StructuredViewer viewer;
    protected IMakefileTarget fSelectedTarget;
    protected IContainer container;
	
    
    public TargetListViewer(IContainer container) {
        this.container = container;
		if (GNATbenchUIPlugin.getDefault().getImage(BUILD_TARGET_ICON) == null) {
			GNATbenchUIPlugin.getDefault().addImage(BUILD_TARGET_ICON,
					"/img/", "make_target.gif");
		} // if
    } // ctor

        
    protected StructuredViewer createStructuredViewer(Composite parent, int style) {
        tableViewer = new TableViewer(parent, SWT.SINGLE | SWT.BORDER);
        Table table = (Table) tableViewer.getControl();
        TableLayout layout = new TableLayout();
        
        table.setLinesVisible(true);

        layout.addColumnData(new ColumnWeightData(25));
        TableColumn tc = new TableColumn(table, SWT.NONE, 0);
        tc.setText("Target Name");
        tc.setImage(GNATbenchUIPlugin.getDefault().getImage(BUILD_TARGET_ICON));
        tc.setAlignment(SWT.CENTER);
        
        layout.addColumnData(new ColumnWeightData(75));
        tc = new TableColumn(table, SWT.NONE, 1);
        tc.setText("Target Description");

        table.setLayout(layout);
        table.setHeaderVisible(true);

        tableViewer.addSelectionChangedListener(new ISelectionChangedListener() {
        	public void selectionChanged(SelectionChangedEvent e) {
        		TargetListViewer.this.selectionChanged((IStructuredSelection) e.getSelection());
        	}
        });
        
        tableViewer.setContentProvider(new MakefileContentProvider());
        
        // show only targets and ignore other content of fContainer
        tableViewer.addFilter(new ViewerFilter() {
        	public boolean select(Viewer viewer, Object parentElement, Object element) {
        		return (element instanceof IMakefileTarget);
        	}
        });
        
        // sort target names in ascending order
        tableViewer.setSorter(new ViewerSorter());
        
        tableViewer.setLabelProvider(new MakefileLabelProvider());
        tableViewer.setInput(container);

        return tableViewer;
    } // createStructuredViewer
    

    protected void selectionChanged(IStructuredSelection selection) {
        fSelectedTarget = (IMakefileTarget) selection.getFirstElement();
    } // selectionChanged

    
    public void setSelectedTarget(IMakefileTarget target) {
        fSelectedTarget = target;
        if (tableViewer != null) {
            tableViewer.setSelection(new StructuredSelection(fSelectedTarget), false);
        }
    } // setSelectedTarget

    
    public IMakefileTarget getSelectedTarget() {
        return fSelectedTarget;
    } // getSelectedTarget

    
    public void createControl(Composite parent, int style, int span) {
		viewer = createStructuredViewer(parent, style);
		Control control = viewer.getControl();
		GridData gd = new GridData(GridData.FILL_BOTH);
		gd.horizontalSpan = span;
		control.setLayoutData(gd);        
        if (viewer != null && fSelectedTarget != null) {
        	viewer.setSelection(new StructuredSelection(fSelectedTarget));
        }
    } // createControl
    
    
	public StructuredViewer getViewer() {
		return viewer;
	} // getViewer

	
	public Control getControl() {
		return viewer.getControl();
	} // getControl

    
} // TargetListViewer
