package com.adacore.gnatbench.ui.internal.buildtarget;


import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.adacore.gnatbench.core.internal.make.IMakefileTarget;

public class BuildTargetDialog extends Dialog {

	protected TargetListViewer targetView;
	protected IContainer container;
	

	public BuildTargetDialog(Shell shell, IContainer container) {
		super(shell);
		this.container = container;
		targetView = new TargetListViewer(this.container);
	} // BuildTargetDialog

	
	public void setTarget(IMakefileTarget target) {
		targetView.setSelectedTarget(target);
	} // setTarget

	
	public IMakefileTarget getTarget() {
		return targetView.getSelectedTarget();
	} // getTarget

	
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText("Invoke Makefile Target");
	} // configureShell

	
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, "Invoke", true);
		createButton(parent, IDialogConstants.CANCEL_ID, IDialogConstants.CANCEL_LABEL, false);
		getButton(IDialogConstants.OK_ID).setEnabled(targetView.getSelectedTarget() != null);
	} // createButtonsForButtonBar

	
	protected Control createDialogArea(Composite parent) {
		Composite composite = (Composite) super.createDialogArea(parent);
		
		((GridLayout) composite.getLayout()).numColumns = 2;
		
		Label title = new Label(composite, SWT.NONE);
		
		GridData gd = new GridData();
		gd.horizontalSpan = 2;
		title.setLayoutData(gd);
		title.setText("Makefile Targets In Project [" + container.getFullPath().toString().substring(1) + "]");
		
		targetView.createControl(composite, SWT.NULL, 2);

		gd = (GridData) targetView.getControl().getLayoutData();
		gd.heightHint = convertHeightInCharsToPixels(15);
		gd.widthHint = convertWidthInCharsToPixels(100);
		targetView.getControl().setLayoutData(gd);
		
		targetView.getViewer().addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(DoubleClickEvent event) {
				okPressed();
			}
		});
		
		targetView.getViewer().addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				getButton(IDialogConstants.OK_ID).setEnabled(targetView.getSelectedTarget() != null);
			}
		});
		
		return composite;
	} // createDialogArea

	
} // BuildTargetDialog
