/*****************************************************************************
 * Copyright (c) 2007, 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.ui.internal.buildtarget;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;

import com.adacore.gnatbench.core.internal.builder.GNATbenchIncrementalBuilder;
import com.adacore.gnatbench.core.internal.make.IMakefileTarget;

public class BuildTargetAction 
	extends ActionDelegate
	implements IObjectActionDelegate, IWorkbenchWindowActionDelegate
{	

	private IProject project = null;
	
	public void run(IAction action) {
		if (project != null) {
			BuildTargetDialog dialog = new BuildTargetDialog(getShell(), project);
			if (dialog.open() == Window.OK) {
				IMakefileTarget target = dialog.getTarget();
				if (target != null) {
					//  we pass the GNAT macros (for the build command, clean 
					//  command, and project file path) in case the user decides 
					//  to invoke one of the GNAT-defined builder command targets 
					//  via this user-defined target invocation mechanism.
					final String [] params = GNATbenchIncrementalBuilder.macroParamsFromGPR(project);
					target.invoke(params);					
				} // if
			} // if
		} // if
	} // run

	
	public void selectionChanged(IAction action, ISelection selection) {		
		if (selection instanceof IStructuredSelection) {			
			IStructuredSelection sel = (IStructuredSelection) selection;
			Object obj = sel.getFirstElement();
			if (obj != null) {
				if (obj instanceof IResource) {
					IResource resource = (IResource) obj;

					if (resource.getType() != IResource.ROOT) {
						while (resource.getType() != IResource.PROJECT) {
							resource= resource.getParent();
						} // while
					} // if
					if (resource instanceof IProject) {
						project = (IProject)resource;
					} // if
				} 
//				else if (obj instanceof TreeParent) {
//					while (!(obj instanceof ProjectNode)) {
//						obj = ((TreeParent)obj).getParent();
//					} // while
//					if (obj instanceof ProjectNode) {
//						project = ((ProjectNode)obj).getProject().getProject();
//					} // if
//				} // if
			} // if
		} // if
		
		action.setEnabled(project != null);		
	} // selectionChanged
	
	
	protected Shell getShell() {
		IWorkbench workbench = PlatformUI.getWorkbench();
		return workbench.getActiveWorkbenchWindow().getShell();
	} // getShell

	
	public void init(IWorkbenchWindow window) {	}
	
	
	public void setActivePart(IAction action, IWorkbenchPart targetPart) { }
	
	
} // BuildTargetAction
