/*******************************************************************************
 * Copyright (C) 2006-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.builder;

import org.eclipse.core.runtime.IProgressMonitor;

import com.adacore.gnatbench.core.GNATbenchSession;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.builder.CompilationEvent;
import com.adacore.gnatbench.core.internal.builder.IGNATbenchBuildListener;
import com.adacore.gnatbench.core.internal.jobs.ToolMessage;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistry;
import com.adacore.gnatbench.core.internal.utils.ViewUtils;

/**
 * This class will handle creation of compilation tool messages after a build.
 */
public class GNATbenchBuildAnnotate implements IGNATbenchBuildListener {

	public void compilationCompleted (
			CompilationEvent event,
			IProgressMonitor monitor)
	{
		// a flag indicating whether we have a message we can display in the
		// Problems view, and in that case that we want to give that view
		// the focus so the user will know a problem has been discovered
		boolean shouldShowProblemsView = false;

		GNATProjectRegistry reg = (GNATProjectRegistry) GNATbenchSession
				.getDefault().getOrLoadRegistry(event.project);

		reg.removeLastBuildMarkers();

		for (int k = 0; k < event.messages.length; ++k) {
			if (monitor.isCanceled()) {
				break;
			} // if


			// note that the order of testing for matches is important
			// because messages could match more than one regex but that
			// would produce duplicate messages (with different formats).
			// thus the use of 'continue' is important too.

			ToolMessage toolMessage = GNATbenchCorePlugin.getDefault()
					.getMessageFactory().parseMessage(event.messages[k],
							event.rootMessageClass, event.project);

			if (toolMessage != null) {
				shouldShowProblemsView = true;

				reg.addMarkerFromBuild(toolMessage.createMarker());
			}
		} // for

		if (shouldShowProblemsView && event.raiseViews) {
			ViewUtils.showProblemsView();
			shouldShowProblemsView = false;
		} // if
	} // compilationCompleted

} // GNATbenchBuildAnnotate
