/*****************************************************************************
 * Copyright (C) 2007-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.ui.internal.builder;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.console.IConsoleConstants;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.builder.GNATbenchIncrementalBuilder;
import com.adacore.gnatbench.core.internal.make.MakefileTarget;

// for actions that should not go through the IncrementalBuilder defined by Workbench
// because of the semantic mismatch with Ada building (eg full build after an analyze command)

public abstract class AbstractJobBuilderAction
	extends ActionDelegate
	implements IObjectActionDelegate, IWorkbenchWindowActionDelegate
{

	private IProject project = null;

	abstract protected String targetName();


	public void run(IAction action) {
		if (project != null) {
			showConsoleView();
			new MakefileTarget(project, targetName(), null)
				.invoke(GNATbenchIncrementalBuilder.macroParamsFromGPR(project));
		} // if
	} // run


	protected void showConsoleView() {
		try {
			IWorkbenchPage p = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
			p.showView(IConsoleConstants.ID_CONSOLE_VIEW, null, IWorkbenchPage.VIEW_VISIBLE);
		} catch (PartInitException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		} // try
	} // showConsoleView


	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection) {
			IStructuredSelection sel = (IStructuredSelection) selection;
			Object obj = sel.getFirstElement();
			if (obj != null) {
				if (obj instanceof IResource) {
					IResource resource = (IResource) obj;

					if (resource.getType() != IResource.ROOT) {
						while (resource.getType() != IResource.PROJECT) {
							resource= resource.getParent();
						} // while
					} // if
					if (resource instanceof IProject) {
						project = (IProject)resource;
					} // if
				}
//				else if (obj instanceof TreeParent) {
//					while (!(obj instanceof ProjectNode)) {
//						obj = ((TreeParent)obj).getParent();
//					} // while
//					if (obj instanceof ProjectNode) {
//						project = ((ProjectNode)obj).getProject().getProject();
//					} // if
//				} // if
			} // if
		} // if

		action.setEnabled(project != null);
	} // selectionChanged


	public void setActivePart(IAction action, IWorkbenchPart targetPart) { }

	public void init(IWorkbenchWindow window) {}

}
