/*****************************************************************************
 * Copyright (C) 2007-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.ui.internal.builder;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.builder.GNATbenchIncrementalBuilder;

// for actions that can or must go through the Workbench-defined incremental builder,
// such as the clean command

public abstract class AbstractIncrementalBuilderAction
	extends ActionDelegate
	implements IObjectActionDelegate, IWorkbenchWindowActionDelegate
{

	protected IProject project = null;


	abstract protected int targetName();


	protected boolean preBuildSteps(IProject project) {
		return true;
	} // preBuildSteps


	protected void postBuildSteps(IProject project) {
	} // postBuildSteps


	public void run(IAction action) {
		if (project != null) {
			GNATbenchIncrementalBuilder projectBuilder = GNATbenchIncrementalBuilder
					.getBuilder(project);

			if (projectBuilder != null) {
				projectBuilder.forceNextBuild();
			}

			try {
				boolean OK = preBuildSteps(project);
				if (!OK) {
					return;
				} // if
				project.build(targetName(), null);
				postBuildSteps(project);
			} catch (Exception e) {
				GNATbenchCorePlugin.getDefault().logError(null, e);
			}
		} // if
	} // run


	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection) {
			IStructuredSelection sel = (IStructuredSelection) selection;
			Object obj = sel.getFirstElement();
			if (obj != null) {
				if (obj instanceof IResource) {
					IResource resource = (IResource) obj;

					if (resource.getType() != IResource.ROOT) {
						while (resource.getType() != IResource.PROJECT) {
							resource= resource.getParent();
						} // while
					} // if
					if (resource instanceof IProject) {
						project = (IProject)resource;
					} // if
				}
			} // if
		} // if

		action.setEnabled(project != null);
	} // selectionChanged


	public void setActivePart(IAction action, IWorkbenchPart targetPart) { }

	public void init(IWorkbenchWindow window) {}


} // AbstractProject
