/*******************************************************************************
 * Copyright (c) 2005 AdaCore and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.browsing;

/**
 * This node represents a folder in the search window.
 * 
 * @author Quentin Ochem
 */
public class FolderNode extends SearchNode {
	private String fName;

	public FolderNode(String Name, SearchNode parent) {
		super(parent);
		fName = Name;
	}

	/**
	 * Returns the name of the folder, without any slash.
	 * 
	 * @return
	 */
	public String getName() {
		return fName;
	}

	public String toString() {
		return fName;
	}
}
