/*******************************************************************************
 * Copyright (c) 2005, 2007 AdaCore and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.browsing;

import java.util.LinkedList;

import com.adacore.gnatbench.core.internal.analyzer.AdaSimpleConstruct;
import com.adacore.gnatbench.core.internal.analyzer.GeneralizedFile;
import com.adacore.gnatbench.core.internal.analyzer.IAdaConstructFilterProvider;

/**
 * This node represents a file in the search window.
 */
public class FileNode extends SearchNode {
	private GeneralizedFile fFile;
	private String fName;

	
	public FileNode(GeneralizedFile file, SearchNode parent) {
		super(parent);
		fFile = file;
		String [] pathArray = fFile.getOSPath().split("\\\\|/");
		fName = pathArray [pathArray.length - 1];
	}

	/**
	 * Returns the file name of the node.
	 * 
	 * @return
	 */
	public String getName() {
		return fName;
	}
	
	public GeneralizedFile getAdaFile() {
		return fFile;
	}
	
	public ConstructNode getConstructChild(AdaSimpleConstruct construct,
			IAdaConstructFilterProvider object) {
		LinkedList <SearchNode> list = getChildren();
		
		for (SearchNode element : list) {		
			if (element instanceof ConstructNode) {
				ConstructNode constructNode = (ConstructNode) element;
				if (constructNode.getConstruct().equals(construct)) {
					return constructNode;
				}
			}
		}
		
		return null;
	}
}

