/*******************************************************************************
 * Copyright (c) 2005, 2007 AdaCore and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.browsing;

import java.util.LinkedList;

import com.adacore.gnatbench.core.internal.analyzer.AdaSimpleConstruct;
import com.adacore.gnatbench.core.internal.analyzer.IAdaConstructFilterProvider;

/**
 * This node represents a construct in the search window.
 */
public class ConstructNode extends SearchNode {

	AdaSimpleConstruct fConstruct;
	
	/**
	 * Create a construct node based on a parent and a corresponding 
	 * construct.
	 * 
	 * @param parent
	 * @param construct
	 */
	public ConstructNode(SearchNode parent, AdaSimpleConstruct construct) {
		super(parent);
		
		fConstruct = construct;
	}
	
	/**
	 * Return the child corresponding to the construct given in parameter, 
	 * null if none.
	 * 
	 * @param construct
	 * @param object
	 * @return
	 */
	public ConstructNode getConstructChild(AdaSimpleConstruct construct,
			IAdaConstructFilterProvider object) {
		LinkedList <SearchNode> list = getChildren();
		
		for (SearchNode node : list) {
			ConstructNode element = (ConstructNode) node;
			
			if (element.fConstruct.equals(construct)) {
				return element;
			}
		}
		
		return null;
	}
	
	/**
	 * Return the construct corresponding to the current instance.
	 * 
	 * @return
	 */
	public AdaSimpleConstruct getConstruct() {
		return fConstruct;
	}

	public String toString() {
		if (fMatches.size() > 0) {
			return fConstruct.toString() + " (" + fMatches.size() + " matches)";
		} else {
			return fConstruct.toString();
		}
	}
}
