/*******************************************************************************
 * Copyright (c) 2005, 2007 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.browsing;

import java.io.IOException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

import com.adacore.gnatbench.core.internal.analyzer.AdaEntityReference;
import com.adacore.gnatbench.core.internal.browsing.AdaCodeBrowser;
import com.adacore.gnatbench.core.analyzer.IAdaEntityReference.SearchScopes;
import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;
import com.adacore.gnatbench.ui.internal.adaeditor.AdaEditor;

public class AdaQueryAllReferences implements ISearchQuery {

	private AdaEntityReference fReference;
	private AdaSearchResult fSearchResults;
	private AdaEditor fEditor;
	private SearchScopes fScope;

	/**
 	 * Creates a query that looks for the references given in parameter, 
	 * extracted from an editor.
	 *
	 * @param reference
	 * @param editor The editor where the reference comes from.
	 * @param scope can be AdaCodeBrowser.SCOPE_WORKSPACE or 
	 * AdaCoreBrowser.SCOPE_PROJECT
	 * @throws GPSError
	 * @throws IOException
	 */
	public AdaQueryAllReferences(AdaEntityReference reference,
			AdaEditor editor, SearchScopes scope)
			throws IOException {
		fReference = reference;
		fSearchResults = new AdaSearchResult(this, "Ada references for \""
				+ reference.getName() + "\"", reference.getName());
		fEditor = editor;
		fScope = scope;
	}

	public IStatus run(IProgressMonitor monitor)
			throws OperationCanceledException {
		fSearchResults.setResults(AdaCodeBrowser.getLocations(fReference,
				fScope, monitor), monitor);

		monitor.done();

		return new Status(IStatus.OK, GNATbenchUIPlugin.getId(), IStatus.OK,
				"", null);
	}

	public String getLabel() {
		return "Ada search for " + fReference.getName();
	}

	public boolean canRerun() {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean canRunInBackground() {
		return true;
	}

	public ISearchResult getSearchResult() {
		return fSearchResults;
	}
	
	public AdaEditor getEditor() {
		return fEditor;
	}
}