/*****************************************************************************
 * Copyright (c) 2007 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.ui.internal.browsing;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.adaeditor.AbstractAdaEditor;
import com.adacore.gnatbench.core.internal.analyzer.AdaEntityReference;

public class AdaHyperlinkDetector extends AbstractHyperlinkDetector {

	public IHyperlink[] detectHyperlinks(ITextViewer textViewer,
			IRegion region, boolean canShowMultipleHyperlinks) {

		String contentType;

		try {
			IDocumentExtension3 extension = (IDocumentExtension3) textViewer
					.getDocument();
			contentType = extension.getContentType(
					GNATbenchCorePlugin.ADA_PARTITIONING, region.getOffset(),
					false);
		} catch (BadLocationException e1) {
			return null;
		} catch (BadPartitioningException e1) {
			return null;
		}

		if (contentType != IDocument.DEFAULT_CONTENT_TYPE) {
			return null;
		}

		AbstractAdaEditor editor = (AbstractAdaEditor) getAdapter(AbstractAdaEditor.class);

		AdaEntityReference entity = editor.getDocumentBuffer().getEntity(
				region.getOffset());

		if (entity == null || !entity.isRegularIdentifier()) {
			return null;
		} else {
			return new IHyperlink[] { new AdaHyperlink(entity) };
		}
	}
}
