/*****************************************************************************
 * Copyright (C) 2007-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.ui.internal.browsing;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.analyzer.AdaEntityReference;
import com.adacore.gnatbench.core.internal.analyzer.GeneralizedLocation;
import com.adacore.gnatbench.core.internal.gpswrappers.Entity;
import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;
import com.adacore.gnatbench.ui.internal.adaeditor.AdaEditor;

public class AdaHyperlink implements IHyperlink {

	AdaEntityReference fEntity;

	public AdaHyperlink (AdaEntityReference ref) {
		fEntity = ref;
	}

	public IRegion getHyperlinkRegion() {
		return new Region(fEntity.getOffset(), fEntity.getLocation()
				.getLength());
	}

	public String getHyperlinkText() {
		return fEntity.getName();
	}

	public String getTypeLabel() {
		return fEntity.getName();
	}

	public void open() {
		try {
			if (fEntity == null) return;

			String entityName = fEntity.getName();

			int lineNumber = fEntity.getLocation().getLine ();

			Entity focusedEntity = new Entity(fEntity);

			GeneralizedLocation spec = focusedEntity.getSpec();

			if (spec == null) return;

			if (spec.getLine() == lineNumber
					&& spec.getFile().getOSPath().equals(
							fEntity.getLocation().getFile().getOSPath()))
			{
				GeneralizedLocation body = focusedEntity.getBody();

				if (body != null) {
					IEditorPart newEditor = GNATbenchUIPlugin.getDefault()
							.openEditor(body);

					if (newEditor instanceof AdaEditor) {
						AdaEditor adaEditor = (AdaEditor) newEditor;

						body = adaEditor.getDocumentBuffer()
								.getClosestLocation(body, entityName);
						adaEditor.focus(body);
					}
				}
			} else {
				IEditorPart newEditor = GNATbenchUIPlugin.getDefault()
						.openEditor(spec);

				if (newEditor instanceof AdaEditor) {
					AdaEditor adaEditor = (AdaEditor) newEditor;

					spec = adaEditor.getDocumentBuffer()
							.getClosestLocation(spec, entityName);
					adaEditor.focus(spec);
				}
			}
		} catch (PartInitException e1) {
			GNATbenchCorePlugin.getDefault().logError(null, e1);
		}
	}

}
