/*******************************************************************************
 * Copyright (c) 2005 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.browsing;

import java.util.Iterator;
import java.util.LinkedList;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.jface.viewers.IStructuredContentProvider;

import com.adacore.gnatbench.core.internal.analyzer.AdaConstruct;

/**
 * The main purpose of this class is to give a way to remove entries in the call
 * tree history list.
 *
 */
public class AdaCallTreeHistoryDialog extends SelectionDialog {

	private TableViewer fViewer;

	private Button fRemoveButton;

	private AdaCallTree fTree;

	private LinkedList<AdaConstruct> fRemoved = new LinkedList<AdaConstruct>();

	private LinkedList<AdaConstruct> fDisplayed = new LinkedList<AdaConstruct>();

	/**
	 * Provides content for the dialog, e.g. the remaining constructs.
	 */
	private class HistoryContentProvider implements IStructuredContentProvider {

		public Object[] getElements(Object inputElement) {
			return fDisplayed.toArray();
		}

		public void dispose() {
			// TODO Auto-generated method stub

		}

		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			// TODO Auto-generated method stub

		}

	}

	/**
	 * Provide label for constructs.
	 */
	private class HistoryLabelProvider implements ILabelProvider {

		public Image getImage(Object element) {
			if (element instanceof AdaConstruct) {
				return ((AdaConstruct) element).getImage();
			}

			return null;
		}

		public String getText(Object element) {
			// TODO Auto-generated method stub
			return element.toString();
		}

		public void addListener(ILabelProviderListener listener) {
			// TODO Auto-generated method stub

		}

		public void dispose() {
			// TODO Auto-generated method stub

		}

		public boolean isLabelProperty(Object element, String property) {
			// TODO Auto-generated method stub
			return false;
		}

		public void removeListener(ILabelProviderListener listener) {
			// TODO Auto-generated method stub

		}

	}

	public AdaCallTreeHistoryDialog(Shell parentShell, AdaCallTree callTree) {
		super(parentShell);

		this.setTitle("Call Hierarchy History");

		fTree = callTree;
		fDisplayed = new LinkedList <AdaConstruct> (callTree.getHistory ());
	}

	/*
	 * Overrides method from Dialog
	 */
	protected Control createDialogArea(Composite container) {
		Composite ancestor = (Composite) super.createDialogArea(container);

		createMessageArea(ancestor);

		Composite parent = new Composite(ancestor, SWT.NONE);

		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		parent.setLayout(layout);

		fViewer = new TableViewer(parent, SWT.MULTI | SWT.H_SCROLL
				| SWT.V_SCROLL | SWT.BORDER | SWT.FULL_SELECTION);
		fViewer.setContentProvider(new HistoryContentProvider());

		final Table table = fViewer.getTable();

		fViewer.setLabelProvider(new HistoryLabelProvider());
		GridData gd = new GridData(GridData.FILL_BOTH);
		gd.heightHint = convertHeightInCharsToPixels(15);
		table.setLayoutData(gd);

		fRemoveButton = new Button(parent, SWT.PUSH);
		fRemoveButton.setText("Remove");
		fRemoveButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				IStructuredSelection sel = (IStructuredSelection) fViewer
						.getSelection();

				for (Iterator iter = sel.iterator(); iter.hasNext();) {
					AdaConstruct construct = (AdaConstruct) iter.next();

					fRemoved.add(construct);
					fDisplayed.remove(construct);
					fViewer.setInput(fTree);
				}
			}
		});
		fRemoveButton.setLayoutData(new GridData(GridData.BEGINNING,
				GridData.BEGINNING, false, false));

		applyDialogFont(ancestor);

		// set input & selections last, so all the widgets are created.
		fViewer.setInput(fTree);
		return table;
	}

	public LinkedList <AdaConstruct> getRemoved() {
		return fRemoved;
	}

}
