/*******************************************************************************
 * Copyright (C) 2005-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.browsing;

import java.io.IOException;
import java.util.ResourceBundle;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.TextEditorAction;

import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;
import com.adacore.gnatbench.ui.internal.adaeditor.AdaEditor;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.analyzer.AdaEntityReference;
import com.adacore.gnatbench.core.internal.browsing.IAdaEntitySelectionProvider;
import com.adacore.gnatbench.core.analyzer.IAdaEntityReference.SearchScopes;

import org.eclipse.search.ui.NewSearchUI;

public class AdaActionReferences extends TextEditorAction {

	private AdaEditor fEditor;
	private IAdaEntitySelectionProvider fSelectionProvider;
	private SearchScopes fScope;

	/**
	 * @param bundle
	 * @param prefix
	 * @param editor
	 * @param scope can be AdaCodeBrowser.SCOPE_WORKSPACE or
	 * AdaCoreBrowser.SCOPE_PROJECT
	 */
	public AdaActionReferences(ResourceBundle bundle, String prefix,
			AdaEditor editor, IAdaEntitySelectionProvider selectionProvider,
			SearchScopes scope) {
		super(bundle, prefix, editor);
		setActionDefinitionId(GNATbenchUIPlugin.getId()	+ ".AdaReferencesInProject");
		setImageDescriptor(GNATbenchUIPlugin.getDefault().getImageDescriptor(
				"/img/", "search_ref_obj.gif"));
		fEditor = editor;
		fSelectionProvider = selectionProvider;
		fScope = scope;
	}

	public void run() {
		AdaEntityReference entity = fSelectionProvider.getEntitySelected();

		if (entity == null) return;

		NewSearchUI.activateSearchResultView();

		try {
			NewSearchUI.runQueryInBackground(new AdaQueryAllReferences(entity,
					(AdaEditor) fEditor, fScope));
		} catch (IOException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		}

		/*
		 * NewSearchUI.runQueryInBackground (new Ada_Query_All_References
		 * (Entity, adaEditor.getInputName()));
		 */
	}

	public void selectionChanged(IAction action, ISelection selection) {

	}

	public void setActivePart(IAction action, IWorkbenchPart targetPart) {

	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
	 */
	public void dispose() {

	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
	 */
	public void init(IWorkbenchWindow window) {
		// TODO Auto-generated method stub

	}

}