/*******************************************************************************
 * Copyright (C) 2005-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.browsing;

import java.util.ResourceBundle;

import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.TextEditorAction;

import com.adacore.gnatbench.library.Language.Language_Category;
import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;
import com.adacore.gnatbench.ui.internal.adaeditor.AdaEditor;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.analyzer.AdaConstruct;
import com.adacore.gnatbench.core.internal.analyzer.AdaConstructCutFilter;
import com.adacore.gnatbench.core.internal.analyzer.AdaConstructFilter;
import com.adacore.gnatbench.core.internal.analyzer.AdaEntityReference;
import com.adacore.gnatbench.core.internal.analyzer.GeneralizedLocation;
import com.adacore.gnatbench.core.internal.analyzer.IAdaConstructFilterProvider;
import com.adacore.gnatbench.core.internal.gpswrappers.Entity;

public class AdaActionOpenDeclaration extends TextEditorAction {

	private AdaEditor fEditor;

	/**
	 * @param bundle
	 * @param prefix
	 * @param editor
	 */
	public AdaActionOpenDeclaration(ResourceBundle bundle, String prefix,
			AdaEditor editor) {
		super(bundle, prefix, editor);

		fEditor = editor;
	}

	public void run() {
		AdaEntityReference reference = fEditor.getEntitySelected();

		if (reference.getName().equals("\n") ||
			reference.getName().trim().equalsIgnoreCase("")) {

			// the cursor was not on an entity, so we look for the
			// enclosing construct

			final GeneralizedLocation currentLocation = fEditor
					.getCurrentLocation();

			AdaConstruct enclosingConstruct = fEditor.getAnalyzer()
					.getConstructAt(currentLocation, new ProgramUnits());

			if (enclosingConstruct != null) {
				reference = fEditor.getDocumentBuffer().getEntity(
						enclosingConstruct.getOffsetEntity());
			}

		}

		try {
			Entity entity = new Entity(reference);

			GeneralizedLocation spec = entity.getSpec();

			if (spec != null) {
				GNATbenchUIPlugin.getDefault().openEditor(spec);
			}
		} catch (PartInitException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		}
	}


	protected class ProgramUnits implements IAdaConstructFilterProvider {

		public boolean isClosable(AdaConstruct element) {
			int category = element.getCategory();
			return category == Language_Category.Cat_Package
			    || category == Language_Category.Cat_Task
			    || category == Language_Category.Cat_Protected
			    || category == Language_Category.Cat_Procedure
			    || category == Language_Category.Cat_Function;
		} // isClosable

		public AdaConstructFilter getFilter() {
			return new AdaConstructCutFilter () {
				public boolean simpleFilter(AdaConstruct construct) {
					return isClosable (construct);
				}
			};
		} // getFilter

	} // ProgramUnits

}