/*******************************************************************************
 * Copyright (C) 2005-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/
package com.adacore.gnatbench.ui.internal.browsing;

import java.util.ResourceBundle;

import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.TextEditorAction;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;
import com.adacore.gnatbench.ui.internal.adaeditor.AdaEditor;

public class AdaActionOpenCallHierarchy extends TextEditorAction {

	private AdaEditor fEditor;

	/**
	 * @param bundle
	 * @param prefix
	 * @param editor
	 */
	public AdaActionOpenCallHierarchy(ResourceBundle bundle, String prefix,
			AdaEditor editor) {
		super(bundle, prefix, editor);

		fEditor = editor;
	}

	public void run () {
		IWorkbenchPage page = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage();
		AdaCallTree callView = null;

		try {
			callView = (AdaCallTree) page.showView(GNATbenchUIPlugin.getId()
					+ ".AdaCallTree");
		} catch (PartInitException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
			return;
		}

		callView.setRootEntity(fEditor.getEntitySelected());
	}

}
