/*******************************************************************************
 * Copyright (c) 2005, 2008 AdaCore and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.analyzer;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

import com.adacore.gnatbench.core.internal.analyzer.AdaSimpleConstruct;
import com.adacore.gnatbench.core.internal.analyzer.IAdaConstructIconProvider;
import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;
import com.adacore.gnatbench.library.Language.Construct_Visibility;
import com.adacore.gnatbench.library.Language.Language_Category;

/**
 * Default UI implementation for icon provider
 */
public class DefaultConstructIconProvider implements IAdaConstructIconProvider {

	final static private String ICON_PUBLIC_PACKAGE = "icon_public_package";
	final static private String ICON_PRIVATE_PACKAGE = "icon_private_package";
	final static private String ICON_FIELD_PUBLIC = "icon_field_public";
	final static private String ICON_FIELD_PRIVATE = "icon_field_private";
	final static private String ICON_METHOD_PUBLIC = "icon_method_public";
	final static private String ICON_METHOD_PRIVATE = "icon_method_private";
	final static private String ICON_TYPE_PUBLIC = "icon_type_public";
	final static private String ICON_TYPE_PRIVATE = "icon_type_private";
	final static private String ICON_WITH = "icon_with";

	public DefaultConstructIconProvider() {
		if (GNATbenchUIPlugin.getDefault().getImage(ICON_PUBLIC_PACKAGE) == null) {
			GNATbenchUIPlugin.getDefault().addImage(ICON_PUBLIC_PACKAGE,
					"/img/", "packd_obj.gif");
			GNATbenchUIPlugin.getDefault().addImage(ICON_PRIVATE_PACKAGE,
					"/img/", "package_private_obj.gif");
			GNATbenchUIPlugin.getDefault().addImage(ICON_FIELD_PRIVATE,
					"/img/", "field_private_obj.gif");
			GNATbenchUIPlugin.getDefault().addImage(ICON_FIELD_PUBLIC, "/img/",
					"field_public_obj.gif");
			GNATbenchUIPlugin.getDefault().addImage(ICON_METHOD_PUBLIC,
					"/img/", "methpub_obj.gif");
			GNATbenchUIPlugin.getDefault().addImage(ICON_METHOD_PRIVATE,
					"/img/", "methpri_obj.gif");
			GNATbenchUIPlugin.getDefault().addImage(ICON_TYPE_PUBLIC, "/img/",
					"type_public_obj.gif");
			GNATbenchUIPlugin.getDefault().addImage(ICON_TYPE_PRIVATE, "/img/",
					"type_private_obj.gif");
			GNATbenchUIPlugin.getDefault().addImage(ICON_WITH, "/img/",
					"imp_obj.gif");
		}
	}

	public Image getImage(AdaSimpleConstruct construct) {
		return getImage (construct.getCategory(), construct.getVisibility());
	}
	
	public String getImageId(int category, int visibility) {
		String id = null;

		switch (category) {
		case Language_Category.Cat_Package:
			if (visibility == Construct_Visibility.Visibility_Public) {
				id = ICON_PUBLIC_PACKAGE;
			} else {
				id = ICON_PRIVATE_PACKAGE;
			}
			break;
		case Language_Category.Cat_Method:
		case Language_Category.Cat_Function:
		case Language_Category.Cat_Procedure:
		case Language_Category.Cat_Entry:
			if (visibility == Construct_Visibility.Visibility_Public) {
				id = ICON_METHOD_PUBLIC;
			} else {
				id = ICON_METHOD_PRIVATE;
			}
			break;
		case Language_Category.Cat_Parameter:
			id = ICON_FIELD_PUBLIC;
			break;
		case Language_Category.Cat_Variable:
		case Language_Category.Cat_Local_Variable:
		case Language_Category.Cat_Field:		
			if (visibility == Construct_Visibility.Visibility_Public) {
				id = ICON_FIELD_PUBLIC;
			} else {
				id = ICON_FIELD_PRIVATE;
			}
			break;
		case Language_Category.Cat_Structure:
		case Language_Category.Cat_Type:
		case Language_Category.Cat_Protected:
		case Language_Category.Cat_Subtype:
		case Language_Category.Cat_Class:
		case Language_Category.Cat_Union:
		case Language_Category.Cat_Task:
			if (visibility == Construct_Visibility.Visibility_Public) {
				id = ICON_TYPE_PUBLIC;
			} else {
				id = ICON_TYPE_PRIVATE;
			}
			break;
		case Language_Category.Cat_With:
		case Language_Category.Cat_Use:
			id = ICON_WITH;
			break;
		}

		return id;
	}

	public ImageDescriptor getImageDescriptor(AdaSimpleConstruct construct) {
		return getImageDescriptor (construct.getCategory(), construct.getVisibility());
	}

	public ImageDescriptor getImageDescriptor(int category, int visibility) {
		// TODO Auto-generated method stub
		return GNATbenchUIPlugin.getDefault().getImageDescriptor(
				getImageId(category, visibility));
	}

	public Image getImage(int category, int visibility) {
		return GNATbenchUIPlugin.getDefault().getImage(
				getImageId(category, visibility));
	}

}
