/*******************************************************************************
 * Copyright (c) 2005, 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.analyzer;

import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

import com.adacore.gnatbench.core.internal.analyzer.AdaConstruct;
import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;
import com.adacore.gnatbench.library.Language.Language_Category;

public class AdaConstructSynchronizedDecorator implements
		ILightweightLabelDecorator {
	
	final static String fgImgName = "sync_ovr.gif";
	
	public void decorate(Object element, IDecoration decoration) {
		AdaConstruct construct = null;
		
		if (element instanceof AdaConstruct)
			construct = (AdaConstruct) element;
//		else if (element instanceof AdaEntityNode)
//			construct = ((AdaEntityNode) element).getConstruct();
		
		if (construct != null) {
			if (construct.getCategory() == Language_Category.Cat_Protected
					|| construct.getCategory() == Language_Category.Cat_Task
					|| construct.getCategory() == Language_Category.Cat_Entry) {
				decoration.addOverlay(GNATbenchUIPlugin.getDefault()
						.getImageDescriptor("/img/", fgImgName));
			}

			if (construct.getCategory() == Language_Category.Cat_Procedure
					|| construct.getCategory() == Language_Category.Cat_Function) {
				AdaConstruct parent = construct.getParent(null);

				if (parent != null
						&& (parent.getCategory() == Language_Category.Cat_Protected || parent
								.getCategory() == Language_Category.Cat_Task)) {
					decoration.addOverlay(GNATbenchUIPlugin.getDefault()
							.getImageDescriptor("/img/", fgImgName));
				}
			}
		}
	}

	public void addListener(ILabelProviderListener listener) {
		
	}

	public void dispose() {
		
	}

	public boolean isLabelProperty(Object element, String property) {

		return false;
	}

	public void removeListener(ILabelProviderListener listener) {
		
	}
	
}