/*****************************************************************************
 * Copyright (C) 2006-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.ui.internal.adaeditor;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

import com.adacore.gnatbench.core.GNATbenchSession;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.analyzer.GeneralizedFile;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistry;
import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;

/**
 * This action will launch the "Open from GPR" view, and open the corresponding
 * file.
 */
public class OpenFileFromProjectAction implements
		IObjectActionDelegate {

	private IProject fProject;

	public void run(IAction action) {
		GNATProjectRegistry registry = (GNATProjectRegistry) GNATbenchSession
				.getDefault().getOrLoadRegistry(fProject);

		OpenFileFromProject dialog = new OpenFileFromProject(registry, Display
				.getCurrent().getActiveShell());

		int result = dialog.open();

		if (result == Dialog.OK) {
			try {
				GNATbenchUIPlugin.getDefault()
						.openEditor(
								GeneralizedFile.fromOSPath(null, registry
										.getSourcePath(dialog.getValue())
										.toOSString()));
			} catch (PartInitException e) {
				GNATbenchCorePlugin.getDefault().logError(null, e);
			}
		}
	}

	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection) {

			IStructuredSelection sel = (IStructuredSelection) selection;

			if (sel.getFirstElement() != null) {
				fProject = (IProject) sel.getFirstElement();
			}
		}
	}

	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		// TODO Auto-generated method stub

	}
}
