/*******************************************************************************
 * Copyright (c) 2005, 2007 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.adaeditor;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

import com.adacore.gnatbench.core.internal.adaeditor.AdaCharacterRule;
import com.adacore.gnatbench.core.internal.adaeditor.AdaCommentRule;
import com.adacore.gnatbench.core.internal.adaeditor.AdaKeywordRule;
import com.adacore.gnatbench.core.internal.adaeditor.AdaNumberRule;
import com.adacore.gnatbench.core.internal.adaeditor.AdaStringRule;
import com.adacore.gnatbench.core.internal.adaeditor.AdaWordDetector;
import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;

/**
 * This files contains a basic set of rules for simple syntax coloration.
 * 
 * @author ochem
 */
public class AdaSyntaxHighlighting extends RuleBasedScanner {

    public AdaSyntaxHighlighting() {
        updateFromPreferences();
    }

    /**
     * Loads the preferences and set the scanner with them. This function has
     * to be called each time the preferences change.
     */
    public void updateFromPreferences() {
		IToken keyword = new Token(new TextAttribute(new Color(Display
				.getCurrent(), PlatformUI.getWorkbench().getThemeManager()
				.getCurrentTheme().getColorRegistry().getRGB(
						GNATbenchUIPlugin.getId() + ".colorkeyword")), null,
				SWT.BOLD));

		IToken comment = new Token(new TextAttribute(new Color(Display
				.getCurrent(), PlatformUI.getWorkbench().getThemeManager()
				.getCurrentTheme().getColorRegistry().getRGB(
						GNATbenchUIPlugin.getId() + ".colorcomment"))));

		IToken string = new Token(new TextAttribute(new Color(Display
				.getCurrent(), PlatformUI.getWorkbench().getThemeManager()
				.getCurrentTheme().getColorRegistry().getRGB(
                		GNATbenchUIPlugin.getId() + ".colorstring"))));

		IToken numericLiteral = new Token(new TextAttribute(new Color(Display
				.getCurrent(), PlatformUI.getWorkbench().getThemeManager()
				.getCurrentTheme().getColorRegistry().getRGB(
                		GNATbenchUIPlugin.getId() + ".colornumericliteral"))));

		IToken wordDefault = new Token(new TextAttribute(new Color(Display
				.getCurrent(), PlatformUI.getWorkbench().getThemeManager()
				.getCurrentTheme().getColorRegistry().getRGB(
                		GNATbenchUIPlugin.getId() + ".colordefault"))));
		
		IToken annotation = new Token(new TextAttribute(new Color(Display
				.getCurrent(), PlatformUI.getWorkbench().getThemeManager()
				.getCurrentTheme().getColorRegistry().getRGB(
                		GNATbenchUIPlugin.getId() + ".colorannotation"))));
		
        List <IRule> rules = new ArrayList<IRule>();

        rules.add(new AdaCommentRule(comment, annotation)); //$NON-NLS-1$

        rules.add(new AdaCharacterRule(string));

        rules.add(new AdaStringRule(string));
        
        rules.add(new AdaKeywordRule(keyword));
        
		WordRule wordRule= new WordRule(new AdaWordDetector(), wordDefault);
        
        rules.add(wordRule);
        
        rules.add(new AdaNumberRule(numericLiteral));
        
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        setRules(result);
    }
}