/*******************************************************************************
 * Copyright (C) 2005-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.adaeditor;

import java.util.Map;

import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.adaeditor.AdaEditorToolPreferencesProvider;
import com.adacore.gnatbench.core.internal.adaeditor.AdaPartitionScanner;
import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;
import com.adacore.gnatbench.ui.internal.codeassist.AdaCompletionProcessor;
import com.adacore.gnatbench.ui.internal.codeassist.HTMLTextPresenter;
import com.adacore.gnatbench.ui.internal.codingstyle.AdaMainAutoEditStrategy;
import com.adacore.gnatbench.ui.internal.quickfix.GNATbenchQuickAssistAssistant;

/**
 * @author ochem
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class AdaSourceViewerConfiguration extends TextSourceViewerConfiguration {

    private AdaEditor fEditor;
    private ContentAssistant fContentAssistant;

    public AdaSourceViewerConfiguration (AdaEditor editor) {
    	super (editor.getPreferenceStorePublic());

       fEditor = editor;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return GNATbenchCorePlugin.ADA_PARTITIONING;
    }

	/* (non-Javadoc)
	 * Method declared on SourceViewerConfiguration
	 */
	public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
		return new String[] {
		  IDocument.DEFAULT_CONTENT_TYPE,
		  AdaPartitionScanner.ADA_COMMENT,
		  AdaPartitionScanner.ADA_CHARACTER,
		  AdaPartitionScanner.ADA_STRING
		 };
	}

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler= new PresentationReconciler();

        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(
				GNATbenchUIPlugin.getDefault().getCodeScanner());
		reconciler.setDamager(dr, IDocument.DEFAULT_CONTENT_TYPE);
		reconciler.setRepairer(dr, IDocument.DEFAULT_CONTENT_TYPE);

        return reconciler;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer,
            String contentType) {
        return new IAutoEditStrategy[] { new AdaMainAutoEditStrategy(fEditor
				.getDocumentBuffer()) };
    }

    /*public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
    	return new AdaTextHover ();
    }*/

	public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
		return new AdaAnnotationHover();
	}

	public IContentAssistant getContentAssistant (ISourceViewer sv) {
		if (fContentAssistant != null) {
			return fContentAssistant;
		} else if (GNATbenchCorePlugin.getDefault().getPreferenceStore().getBoolean(
				AdaEditorToolPreferencesProvider.PREF_TOOLS_CODE_ASSIST)) {
			fContentAssistant = new ContentAssistant();
			IContentAssistProcessor pr = new AdaCompletionProcessor(fEditor,
					fContentAssistant);

			fContentAssistant.setContentAssistProcessor(pr, IDocument.DEFAULT_CONTENT_TYPE);
			fContentAssistant.setInformationControlCreator(getInformationControlCreator(sv));

			fContentAssistant
					.enableAutoActivation(GNATbenchCorePlugin
							.getDefault()
							.getPreferenceStore()
							.getBoolean(
									AdaEditorToolPreferencesProvider.PREF_TOOLS_CODE_ASSIST_AUTO_ACTIVATION));

			fContentAssistant
					.setAutoActivationDelay(GNATbenchCorePlugin
							.getDefault()
							.getPreferenceStore()
							.getInt(
									AdaEditorToolPreferencesProvider.PREF_TOOLS_CODE_ASSIST_DELAY));

			return fContentAssistant;
		} else {
			return super.getContentAssistant(sv);
		}
	}

	@Override
	public IInformationControlCreator getInformationControlCreator(ISourceViewer sv) {
		return new IInformationControlCreator() {
			public IInformationControl createInformationControl(Shell parent) {
				return new DefaultInformationControl(parent, new HTMLTextPresenter());
//				return new DefaultInformationControl(parent, true);
			}
		};
	}

	@Override
	public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
		return new GNATbenchQuickAssistAssistant (fEditor);
	}

	@SuppressWarnings("unchecked")
	@Override
	protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
		Map targets= super.getHyperlinkDetectorTargets(sourceViewer);
		targets.put("com.adacore.gnatbench.ui.adaCode", fEditor); //$NON-NLS-1$
		return targets;
	}
}
