/*******************************************************************************
 * Copyright (C) 2005-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.adaeditor;


import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.analyzer.GeneralizedFile;
import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;

/**
 * This class provide a "open external file" action for ada files, since the
 * regular one imposes a java input.
 *
 * @author Quentin Ochem
 */
public class AdaOpenExternalFileAction implements
		IWorkbenchWindowActionDelegate {


	private IWorkbenchWindow fWindow;

	/**
	 * The constructor.
	 */
	public AdaOpenExternalFileAction() {
	}

	/**
	 * @see IWorkbenchWindowActionDelegate#run
	 */
	public void run(IAction action) {
		FileDialog dialog = new FileDialog(fWindow.getShell());

		GeneralizedFile file = GeneralizedFile.fromOSPath(null,
				dialog.open());

		try {
			GNATbenchUIPlugin.getDefault().openEditor(file);
		} catch (PartInitException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		}
	}

	/**
	 * @see IWorkbenchWindowActionDelegate#selectionChanged
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * @see IWorkbenchWindowActionDelegate#dispose
	 */
	public void dispose() {
	}

	/**
	 * @see IWorkbenchWindowActionDelegate#init
	 */
	public void init(IWorkbenchWindow window) {
		fWindow = window;
	}
}