/*******************************************************************************
 * Copyright (c) 2007 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.adaeditor;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;

import com.adacore.gnatbench.core.internal.preferences.AdaPreferencePage;
import com.adacore.gnatbench.core.internal.preferences.IGNATbenchPreferencesProvider;
import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;

public class AdaEditorPreferences implements IGNATbenchPreferencesProvider {

	protected final static String ADA_MATCHING_BRACKETS =  
		GNATbenchUIPlugin.getId() + ".matching_brackets";
	
	protected final static String ADA_MATCHING_BRACKETS_COLOR = 
		GNATbenchUIPlugin.getId() + ".matching_brackets_color";
	
	public static final String INSERT_HEADER_FILE = 
		GNATbenchUIPlugin.getId() + ".insert_header_file";

	public static final String SPEC_HEADER_FILE_NAME = 
		GNATbenchUIPlugin.getId() + ".insert_header_file_name_specs";

	public static final String BODY_HEADER_FILE_NAME = 
		GNATbenchUIPlugin.getId() + ".insert_header_file_name_bodys";

	public static final String PREF_USE_SMART_SPACE_KEY = 
		GNATbenchUIPlugin.getId() + ".smart_space_key";

	public static final String PREF_USE_SMART_TAB_KEY = 
		GNATbenchUIPlugin.getId() + ".smart_tab_key";

	public static final String PREF_USE_MIN_ABBREVIATION_LENGTH = 
		GNATbenchUIPlugin.getId() + ".space_key_min_abbreviation_length";
	
	public static final String PREF_CODING_STYLE_REMOVE_SPACES = 
		GNATbenchUIPlugin.getId() + ".preferences.coding_style.remove_spaces";

	public void createPreferenceFields(AdaPreferencePage page) {
		page.addField(new BooleanFieldEditor(
				PREF_CODING_STYLE_REMOVE_SPACES, 
				"Remove trailing spaces when saving",
				page.getFieldEditorParent()));	
		
		page.addField(new BooleanFieldEditor(
				PREF_USE_SMART_SPACE_KEY, 
				"Use smart space key",
				page.getFieldEditorParent()));	

		page.addField(new IntegerFieldEditor(
				PREF_USE_MIN_ABBREVIATION_LENGTH, 
				"Minimum word length for expansion consideration",
				page.getFieldEditorParent()));

		page.addField(new BooleanFieldEditor(
				PREF_USE_SMART_TAB_KEY, 
				"Use smart tab key",
				page.getFieldEditorParent()));	

		page.addField(new BooleanFieldEditor(
				ADA_MATCHING_BRACKETS, 
				"Highlight matching brackets",
				page.getFieldEditorParent()));
		
		page.addField(new ColorFieldEditor(
				ADA_MATCHING_BRACKETS_COLOR, 
				"Matching brackets highlight color",
				page.getFieldEditorParent()));

		page.addField(new BooleanFieldEditor(
				INSERT_HEADER_FILE, 
				"Insert header text into new Ada source files",
				page.getFieldEditorParent()));
		
		page.addField(new FileFieldEditor(
				SPEC_HEADER_FILE_NAME, 
				"File containing the header text for specs",
				page.getFieldEditorParent()));
		
		page.addField(new FileFieldEditor(
				BODY_HEADER_FILE_NAME, 
				"File containing the header text for bodies",
				page.getFieldEditorParent()));		
	}

	public void initializeDefaultPreferences(IPreferenceStore store) {
		final IPreferenceStore finalStore = store;
		
		store.setDefault(ADA_MATCHING_BRACKETS, true);
		
		PreferenceConverter.setDefault(finalStore,
				ADA_MATCHING_BRACKETS_COLOR, new RGB(192, 192, 192));

		store.setDefault(INSERT_HEADER_FILE, false);
		
		store.setDefault (PREF_USE_SMART_SPACE_KEY, false);
		store.setDefault (PREF_USE_SMART_TAB_KEY, true);
		store.setDefault (PREF_USE_MIN_ABBREVIATION_LENGTH, 3);
		
		store.setDefault (PREF_CODING_STYLE_REMOVE_SPACES, true);
	}

	public void okPerformed(AdaPreferencePage page) {
		// TODO Auto-generated method stub
		
	}

}
