package com.adacore.gnatbench.ui.internal.adaeditor;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditorPreferenceConstants;

public class AdaEditorPrefUtils {
	
	static final String definingPlugin = "org.eclipse.ui.editors";
	// the plugin that sets the preference


	
    static public int prefPrintMargin(final int defaultMargin) {
    	boolean marginEnabled;
    	int marginColumn = defaultMargin;
    	
    	final int abstractEditorDefault = 80;
    	// The editor hard-codes this as the default.  If the user doesn't
    	// change the value of the margin column from this default the value
    	// is not stored, so we could get marginEnabled as true but no value
    	// read for marginColumn.  Therefore we define this value to match
    	// what the editor uses, and apply it as the default value when 
    	// retrieving the value from the preference store.
    	
    	
    	IScopeContext context = new InstanceScope(); 
    	IEclipsePreferences configNode = context.getNode(definingPlugin);
    	
    	if (configNode == null) {
        	return defaultMargin;			
		} // if
    	
    	marginEnabled = configNode.getBoolean
    		(AbstractDecoratedTextEditorPreferenceConstants.EDITOR_PRINT_MARGIN, 
    				false);

    	if (marginEnabled) {
    		
    		// See if there is a value stored for the column. As noted above, 
    		// the value will be stored only if different from the default
    		// hard-coded by the editor.  This default, specified via the second
    		// parameter to getInt(), will be returned in that case.
    		
    		marginColumn = configNode.getInt
    			(AbstractDecoratedTextEditorPreferenceConstants.EDITOR_PRINT_MARGIN_COLUMN, 
    		     abstractEditorDefault);    	
    	} // if
    	
		return marginColumn;
    } // prefPrintMargin
    
    
    static public int tabWidth() {
    	int width;

    	final int abstractEditorTabDefault = 4;
    	// The editor hard-codes this as the default.  If the user doesn't
    	// change the value from this default then no value
    	// is stored.  Therefore we define this value to match
    	// what the editor uses, and apply it as the default when 
    	// retrieving the value from the preference store.

    	IScopeContext context = new InstanceScope(); 
    	IEclipsePreferences configNode = context.getNode(definingPlugin);
    	
    	if (configNode == null) {
        	return abstractEditorTabDefault;			
		} // if

    	width = configNode.getInt
			(AbstractDecoratedTextEditorPreferenceConstants.EDITOR_TAB_WIDTH, 
			 abstractEditorTabDefault);
    	
    	return width;
    } // tabWidth
 

    static public boolean insertSpacesForTabs() {
    	boolean result;

    	IScopeContext context = new InstanceScope(); 
    	IEclipsePreferences configNode = context.getNode(definingPlugin);
    	
    	if (configNode == null) {
        	return false;			
		} // if

    	result = configNode.getBoolean
			(AbstractDecoratedTextEditorPreferenceConstants.EDITOR_SPACES_FOR_TABS, 
			 false);
    	
    	return result;
    } // insertSpacesForTabs
 

} // AdaEditorPrefUtils
