/*******************************************************************************
 * Copyright (c) 2006, 2008 AdaCore and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.adaeditor;

import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
//import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class AdaEditorActionContributor extends TextEditorActionContributor {
	
	public void setActiveEditor(IEditorPart part) {
		super.setActiveEditor(part);

		ITextEditor textEditor= null;
		if (part instanceof ITextEditor)
			textEditor= (ITextEditor) part;

		// Source menu.
		IActionBars bars= getActionBars();
		// TODO put these string id's into a static constants class like JdtActionsConstants
		bars.setGlobalActionHandler("com.adacore.gnatbench.ui.actions.ToggleComment", getAction(textEditor, "ToggleComment")); //$NON-NLS-1$
		bars.setGlobalActionHandler("com.adacore.gnatbench.ui.actions.AdaNextUnit", getAction(textEditor, "NextAdaUnit")); //$NON-NLS-1$
		bars.setGlobalActionHandler("com.adacore.gnatbench.ui.actions.AdaPrevUnit", getAction(textEditor, "PrevAdaUnit")); //$NON-NLS-1$
		bars.setGlobalActionHandler("com.adacore.gnatbench.ui.actions.Refill", getAction(textEditor, "Refill")); //$NON-NLS-1$
		bars.setGlobalActionHandler("com.adacore.gnatbench.ui.actions.AdaEndCompletion", getAction(textEditor, "InsertEnd")); //$NON-NLS-1$
		bars.setGlobalActionHandler("com.adacore.ui.actions.Indent", getAction(textEditor, "CorrectIndent")); //$NON-NLS-1$
		bars.setGlobalActionHandler("com.adacore.ui.actions.Format", getAction(textEditor, "Format")); //$NON-NLS-1$
		bars.setGlobalActionHandler("com.adacore.ui.actions.GenerateAdaBody", getAction(textEditor, "GenerateBody")); //$NON-NLS-1$
		
	} // setActiveEditor
	
} // AdaEditorActionContributor
	
