/*******************************************************************************
 * Copyright (C) 2005-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.adaeditor;

import java.util.List;

import org.eclipse.jface.text.source.DefaultAnnotationHover;

/**
 * This class is used to display hovers on the left bar of the editor.
 * Basically used to display errors hovers on top of errors annotations.
 *
 */
public class AdaAnnotationHover extends DefaultAnnotationHover {

	@SuppressWarnings("unchecked")
	protected String formatMultipleMessages(List messages) {
		return super.formatMultipleMessages(messages)
				.replaceAll("\n", "<br>\n");
	}
}
