/*******************************************************************************
 * Copyright (C) 2005-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.adaeditor;

import java.util.ResourceBundle;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.ui.texteditor.TextEditorAction;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.library.LibraryMonitor;
import com.adacore.gnatbench.library.LibrarySemaphore;
import com.adacore.gnatbench.library.Language.Ada.Ada_Package;
import com.adacore.gnatbench.library.Standard.AdaString;

public class AdaActionToggleComment extends TextEditorAction {

	private AdaEditor fEditor;

	/**
	 * @param bundle
	 * @param prefix
	 * @param editor
	 */
	public AdaActionToggleComment(ResourceBundle bundle, String prefix,
			AdaEditor editor) {
		super(bundle, prefix, editor);

		fEditor = editor;
	}

	public void run() {
		TextSelection selection = (TextSelection) ((TextViewer) fEditor
				.getSourceViewerPublic()).getSelection();

		comment (selection);
	}

	public void comment (TextSelection selection) {

		final String text = fEditor.getDocumentBuffer().getContent();

		final IDocument document = fEditor.getDocumentBuffer().getDocument();

		try {
			int offsetLineBegin = document.getLineOffset(selection
					.getStartLine());

			int offsetLineEnd;

			if (selection.getLength() > 0) {
				// If selection is bigger than 0 character, then we don't want
				// to take into account the last line if there is no character
				// thenre, hence the -1 to the length.

				offsetLineEnd = text.indexOf("\n", selection.getOffset()
						+ selection.getLength() - 1) - 1;
			} else {
				offsetLineEnd = text.indexOf("\n", selection.getOffset()
						+ selection.getLength()) - 1;
			}


			if (offsetLineEnd < 0) {
				offsetLineEnd = text.length();
			} else if (offsetLineEnd < offsetLineBegin) {
				//  In this case, we are on an empty line

				offsetLineEnd = offsetLineBegin;
			}

			String block = text.substring(offsetLineBegin,
					offsetLineEnd);

			boolean doComment;
			int firstCommentLength = 0;

			if (block.toString().matches
					("((^|\n)\\p{Space}*--([^\n\r])*\r?)+$")) {

				doComment = false;

				int commentIndex = block.toString().indexOf("--") + 2;
				firstCommentLength = -2;

				if (block.length() > commentIndex + 1
						&& Character.isWhitespace(block.charAt(
								commentIndex + 1))) {
					firstCommentLength--;
				}

				if (block.length() > commentIndex + 2
						&& Character.isWhitespace(block.charAt(
								commentIndex + 2))) {
					firstCommentLength--;
				}

				if (-firstCommentLength > selection.getOffset () - offsetLineBegin) {
					firstCommentLength = -(selection.getOffset () - offsetLineBegin);
				}
			} else {
				doComment = true;

				firstCommentLength = 4;

				if (firstCommentLength > selection.getOffset () - offsetLineBegin) {
					firstCommentLength = selection.getOffset () - offsetLineBegin;
				}
			}

			int extraSelectBegin = selection.getOffset() - offsetLineBegin;
			int extraSelectEnd = offsetLineEnd
					- (selection.getOffset() + selection.getLength());

			LibraryMonitor libMonitor = LibrarySemaphore.startGPSWork();

			String result = null;

			try {
				result = Ada_Package.Ada_Lang().Comment_Block(
						new AdaString(block), doComment, false).toString();
			} finally {
				LibrarySemaphore.stopGPSWork(libMonitor);
			}


			document.replace(offsetLineBegin, offsetLineEnd - offsetLineBegin,
					result);

			if (selection.getLength() > 0) {
				((TextViewer) fEditor.getSourceViewerPublic())
						.setSelectedRange(selection.getOffset()
								+ firstCommentLength, result
								.length()
								- extraSelectEnd
								- extraSelectBegin
								- firstCommentLength);
			} else {
				((TextViewer) fEditor.getSourceViewerPublic())
						.setSelectedRange(selection.getOffset()
								+ firstCommentLength, 0);
			}
		} catch (BadLocationException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		}
	}
}
