/*******************************************************************************
 * Copyright (C) 2007-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.adaeditor;

import java.util.ResourceBundle;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.TextEditorAction;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.analyzer.GeneralizedLocation;
import com.adacore.gnatbench.ui.internal.codingstyle.AdaCodingStylePreferencesProvider;

public class AdaActionTabIndent extends TextEditorAction {

	private AdaEditor editor;
    private AdaEditorTextUtils textManager;

	public AdaActionTabIndent(ResourceBundle bundle, String prefix, AdaEditor editor) {
		super(bundle, prefix, editor);
		this.editor = editor;
	} // ctor

	public void run() {
		textManager = new AdaEditorTextUtils(editor);

		// the amount to indent per syntactic level
		final int indentPref = GNATbenchCorePlugin
			.getDefault()
			.getPreferenceStore()
			.getInt(AdaCodingStylePreferencesProvider.PREF_INDENT_LEVEL);

		final boolean prefEnabled = GNATbenchCorePlugin
		.getDefault()
		.getPreferenceStore()
		.getBoolean(
			AdaEditorPreferences.PREF_USE_SMART_TAB_KEY);

		if (!prefEnabled) {
			insertTabOrSpaces(textManager);
			return;
		} // if

		final IDocument document = editor.getDocumentBuffer().getDocument();

		// get the current cursor position
		// we get the column using the "GPS" version accessor function
		// because that version starts with 1, whereas the Eclipse version is
		// zero-based.  The computation of the next tab stop  is based on
		// starting at one.
		GeneralizedLocation loc = editor.getCurrentLocation();
		final int currentColumn = loc.getColumn().getColumnIndex();
		final int currentRow = loc.getLine() - 1;

		try {
			// get the offset within the file of characters to the beginning of
			// the line containing the cursor
			final int offsetLineBegin = document.getLineOffset(currentRow);

			// determine where the next logical "tab stop" would be in terms of the
			// indentation from the user preference and the current column
			int nextTabStop = (((currentColumn + indentPref - 1) / indentPref) * indentPref) + 1;

			// determine the amount of spaces to get to the next tab stop.
			// this is the amount of spaces to insert
			final int offsetFromNextStop = nextTabStop - currentColumn;

			// GPS.Editor.insert_text (' ' * offset);
			// construct a string of the necessary length.
			// if we ever allow users to choose inserting actual tabs instead
			// of spaces, we will move this "tab" into a function that
			// either returns that many spaces or the right number of tabs
			// for the number of spaces (characters) computed.
			StringBuffer tab = new StringBuffer(offsetFromNextStop);
			for (int k = 0; k < offsetFromNextStop; k++) {
				tab.append (' ');
			} // for

			// insert the indentation text
			document.replace(offsetLineBegin + currentColumn - 1, 0, tab.toString());

			// show the cursor at the new position
			editor.selectAndReveal(offsetLineBegin + currentColumn + offsetFromNextStop - 1, 0);

		} catch (BadLocationException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		} // try
	} // run


	protected void insertTabOrSpaces(final AdaEditorTextUtils textManager) {
		try {
			if (AdaEditorPrefUtils.insertSpacesForTabs()) {
				final int width = AdaEditorPrefUtils.tabWidth();
				StringBuffer softTab = new StringBuffer(width);
				for (int k = 0; k < width; k++) {
					softTab.append(' ');
				} // for
				textManager.insertText(softTab.toString());
			} else {
				textManager.insertTab();
			} // if
		} catch (BadLocationException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		} // try
	} // insertTabOrSpaces


} // AdaActionTabIndent
