/*******************************************************************************
 * Copyright (C) 2007-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.adaeditor;

import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.TextEditorAction;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;

public class AdaActionNextSubprogram extends TextEditorAction {

	private AdaEditor editor;
    private IDocument document;

	private final static Pattern regexTargets = Pattern.compile(
			"^([ \\t]*)(procedure|function|entry)\\s*([a-zA-Z0-9_]+).*",
		Pattern.CASE_INSENSITIVE | Pattern.DOTALL);


 	public AdaActionNextSubprogram(ResourceBundle bundle, String prefix, AdaEditor editor) {
		super(bundle, prefix, editor);
		this.editor = editor;
	} // ctor


	public void run() {
		AdaEditorTextUtils Utils = new AdaEditorTextUtils(editor);

		int lineNum = editor.getCurrentLocation().getLine() - 1;

		document = editor.getDocumentBuffer().getDocument();

		final int totalLines = document.getNumberOfLines();

		String line;

		try {

			++lineNum;
			while (lineNum < totalLines) {
				line = Utils.getLine(lineNum);
				Matcher match = regexTargets.matcher(line);
				if (match.matches()) {
					Utils.setCursorPosition(lineNum, 0);
					break;
				} // if
				++lineNum;
			} // while

		} catch (BadLocationException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		} // try
	} // run


} // AdaActionNextSubprogram