/*****************************************************************************
 * Copyright (c) 2005, 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.ui.internal.adaeditor;

import java.util.ResourceBundle;

import org.eclipse.ui.texteditor.TextEditorAction;

import com.adacore.gnatbench.core.GNATbenchSession;
import com.adacore.gnatbench.core.internal.GPS;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistry;
/**
 * Switches the edition to GPS.
 * 
 * @author Quentin Ochem
 */
public class AdaActionEditInGPS extends TextEditorAction {

	AdaEditor fAdaEditor;
	
	/**
	 * @param bundle
	 * @param prefix
	 * @param editor
	 */
	public AdaActionEditInGPS(ResourceBundle bundle, String prefix, AdaEditor editor) {
		super(bundle, prefix, editor);
		
		fAdaEditor = editor;
	}
	
	public void run() {
		GPS.launchGPS(((GNATProjectRegistry) GNATbenchSession.getDefault()
				.getOrLoadRegistry(fAdaEditor.getProject()))
				.getGPRFor(fAdaEditor.getProject()), "open_gps.py", null);
	}

}