/*******************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.adaeditor;

import java.util.ResourceBundle;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.ui.texteditor.TextEditorAction;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.jobs.AnalyzeAdaFilesJob;

/**
 * Launch the compilation of a file from the text editor
 */
public class AdaActionAnalyzeFile extends TextEditorAction {

	protected AdaActionAnalyzeFile(ResourceBundle bundle, String prefix,
			AdaEditor editor) {
		super(bundle, prefix, editor);
	}

	public void run() {
		// retrieve the current file of the Editor and get the corresponding IFileStore
		try {
			IFileStore store = GNATbenchCorePlugin.getDefault().getEFSRegistry().getUniqueStore((((AdaEditor) getTextEditor()).getFile().getFile()).getLocation());
			new AnalyzeAdaFilesJob(new IFileStore[]{store}, true).schedule();
		} catch (GNATbenchCoreException e) {
			GNATbenchCorePlugin.getDefault().logError(null,e);
		}
	}

}
