/*******************************************************************************
 * Copyright (C) 2006-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

import com.adacore.gnatbench.core.GNATbenchSession;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.GNATbenchProjectProperties;

/**
 * Class used to change GNATbench project properties
 */
public class GNATbenchProperties extends PropertyPage {

	private Text fText;
	private Button fIsRootProject;
	private GNATbenchProjectProperties fProps;

	protected IProject getProject () {
		if (this.getElement() instanceof IProject) {
			return (IProject) this.getElement();
		}

		return null;
	}

	protected Control createContents(Composite parent) {
		Composite control = new Composite (parent, 0);

		GridLayout layout = new GridLayout();
		layout.numColumns = 4;

		control.setLayout(layout);

		Label label = new Label (control, 0);
		label.setText("GNAT project file");

		GridData data;

		data = new GridData ();
		data.horizontalAlignment = SWT.FILL;
		data.grabExcessHorizontalSpace = true;
		fText = new Text (control, SWT.BORDER);
		fText.setLayoutData(data);

		fProps = GNATbenchProjectProperties.getPropertiesFor(getProject());
		String projectName = fProps.getGPRPath();

		if (projectName == null) {
			projectName = "";
		}

		// TODO: Put here the relative project name ?
		fText.setText(projectName);

		Button b;

		b = new Button (control, SWT.PUSH);
		b.setText ("Search Project");
		b.addMouseListener(new MouseListener (){

			public void mouseDoubleClick(MouseEvent e) {
				// TODO Auto-generated method stub

			}

			public void mouseDown(MouseEvent e) {

				/**
				 * This class opens a dialog listing all the GPR Files found
				 * in the project, and asking the user to select one.
				 *
				 */
				class WorkspaceFileDialog extends Dialog {

					String result = "";

					public WorkspaceFileDialog (Shell parent) {
						super (parent);
					}

					private void searchInContainer
					   (IContainer container, List list) throws CoreException {

						IResource [] members = container.members();

						for (int i = 0; i < members.length; ++i) {
							IResource element = (IResource) members [i];

							if (element instanceof IContainer) {
								searchInContainer ((IContainer) element, list);
							} else {
								if (element instanceof IFile) {
									IFile file = (IFile) element;

									if ("gpr".equals (file.getFileExtension())) {
										list.add
										(file.getFullPath()
												.removeFirstSegments(1)
												.toOSString());
									}
								}
							}

						}

					}

					public String open () {
						Shell parent = getParent();
						final Shell shell =
							new Shell
							(parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
						shell.setText(getText());

						GridLayout layout = new GridLayout();
						layout.numColumns = 1;

						shell.setLayout(layout);

						// Your code goes here
						// (widget creation, set result, etc).

						Label label = new Label (shell, SWT.CENTER);
						label.setText("Please select a GNAT Project");

						final List l = new List(shell, SWT.SINGLE | SWT.BORDER);

						GridData data = new GridData ();
						data.horizontalSpan = 2;
						data.horizontalAlignment = SWT.FILL;
						data.verticalAlignment = SWT.FILL;

						l.setLayoutData(data);

						try {
							searchInContainer (getProject(), l);
						} catch (CoreException e) {
							GNATbenchCorePlugin.getDefault().logError(null, e);
						}

						Composite buttonsComp =
							new Composite (shell, SWT.NONE);

						GridLayout g1 = new GridLayout ();
						g1.makeColumnsEqualWidth = false;
						g1.numColumns = 2;

						buttonsComp.setLayout(g1);

						Composite emptyComp =
							new Composite (buttonsComp, SWT.NONE);

						data = new GridData ();
						data.horizontalAlignment = SWT.FILL;
						emptyComp.setLayoutData(data);

						Composite filledComp =
							new Composite (buttonsComp, SWT.NONE);

						GridLayout g2 = new GridLayout ();
						g2.makeColumnsEqualWidth = true;
						g2.numColumns = 2;
						filledComp.setLayout(g2);

						Button b;

						data = new GridData ();
						data.horizontalAlignment = SWT.FILL;

						b = new Button (filledComp, SWT.PUSH);
						b.setText("OK");
						b.setLayoutData(data);

						b.addMouseListener(new MouseListener () {

							public void mouseDoubleClick(MouseEvent e) {
								// TODO Auto-generated method stub

							}

							public void mouseDown(MouseEvent e) {
								// TODO Auto-generated method stub

							}

							public void mouseUp(MouseEvent e) {
								if (l.getSelection().length >= 1) {
									result = l.getSelection() [0];
								}

								shell.close();

							}});

						data = new GridData ();
						data.horizontalAlignment = SWT.FILL;

						b = new Button (filledComp, SWT.PUSH);
						b.setText("Cancel");
						b.setLayoutData(data);

						b.addMouseListener(new MouseListener () {

							public void mouseDoubleClick(MouseEvent e) {
								// TODO Auto-generated method stub

							}

							public void mouseDown(MouseEvent e) {
								// TODO Auto-generated method stub

							}

							public void mouseUp(MouseEvent e) {
								result = fText.getText();
								shell.close();

							}});

						shell.pack();

						//  end of the code

						shell.open();
						Display display = parent.getDisplay();
						while (!shell.isDisposed()) {
							if (!display.readAndDispatch()) display.sleep();
						}

						return result;
					}
				}

				WorkspaceFileDialog dialog =
					new WorkspaceFileDialog(getShell());

				dialog.setText("Select a GNAT project file");

				String path = dialog.open();

				if (path != null) {
					fText.setText(path);
				}
			}

			public void mouseUp(MouseEvent e) {
				// TODO Auto-generated method stub

			}});


		b = new Button (control, SWT.PUSH);
		b.setText("Browse");
		b.addMouseListener(new MouseListener (){

			public void mouseDoubleClick(MouseEvent e) {
				// TODO Auto-generated method stub

			}

			public void mouseDown(MouseEvent e) {
				FileDialog dialog = new FileDialog(getShell());
				dialog.setFilterExtensions(new String[] { "*.gpr" });

				String path = dialog.open();

				if (path != null) {
					fText.setText(path);
				}
			}

			public void mouseUp(MouseEvent e) {
				// TODO Auto-generated method stub

			}});


		boolean isRootProject =
			fProps.isRootProject();

		Label label2 = new Label (control, 0);
		label2.setText("Is root project ");

		fIsRootProject = new Button (control, SWT.CHECK);
		fIsRootProject.setSelection(isRootProject);

		return control;
	}

	/**
	 * Changes the gpr file used by this project.
	 *
	 */
	public boolean performOk () {
		fProps.setGPRPath (fText.getText());
		fProps.setRootProject (fIsRootProject.getSelection());
		fProps.saveProjectFile();

		GNATbenchSession.getDefault().getOrLoadRegistry(getProject())
				.recompute();

		return true;

	}

}
